!/**
 * Highstock JS v11.4.0 (2024-03-04)
 *
 * Data grouping module
 *
 * (c) 2010-2024 Torstein Hønsi
 *
 * License: www.highcharts.com/license
 */function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/datagrouping",["highcharts"],function(a){return t(a),t.Highcharts=a,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var a=t?t._modules:{};function i(t,a,i,o){t.hasOwnProperty(a)||(t[a]=o.apply(null,i),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:a,module:t[a]}})))}i(a,"Extensions/DataGrouping/ApproximationRegistry.js",[],function(){return{}}),i(a,"Extensions/DataGrouping/ApproximationDefaults.js",[a["Extensions/DataGrouping/ApproximationRegistry.js"],a["Core/Utilities.js"]],function(t,a){var i=a.arrayMax,o=a.arrayMin,e=a.correctFloat,n=a.extend,r=a.isNumber;function s(t){var a=t.length,i=p(t);return r(i)&&a&&(i=e(i/a)),i}function p(t){var a,i=t.length;if(!i&&t.hasNulls)a=null;else if(i)for(a=0;i--;)a+=t[i];return a}var u={average:s,averages:function(){var t=[];return[].forEach.call(arguments,function(a){t.push(s(a))}),void 0===t[0]?void 0:t},close:function(t){return t.length?t[t.length-1]:t.hasNulls?null:void 0},high:function(t){return t.length?i(t):t.hasNulls?null:void 0},hlc:function(a,i,o){if(a=t.high(a),i=t.low(i),o=t.close(o),r(a)||r(i)||r(o))return[a,i,o]},low:function(t){return t.length?o(t):t.hasNulls?null:void 0},ohlc:function(a,i,o,e){if(a=t.open(a),i=t.high(i),o=t.low(o),e=t.close(e),r(a)||r(i)||r(o)||r(e))return[a,i,o,e]},open:function(t){return t.length?t[0]:t.hasNulls?null:void 0},range:function(a,i){return(a=t.low(a),i=t.high(i),r(a)||r(i))?[a,i]:null===a&&null===i?null:void 0},sum:p};return n(t,u),u}),i(a,"Extensions/DataGrouping/DataGroupingDefaults.js",[],function(){return{common:{groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %e %b, %H:%M:%S.%L","%A, %e %b, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %e %b, %H:%M:%S","%A, %e %b, %H:%M:%S","-%H:%M:%S"],minute:["%A, %e %b, %H:%M","%A, %e %b, %H:%M","-%H:%M"],hour:["%A, %e %b, %H:%M","%A, %e %b, %H:%M","-%H:%M"],day:["%A, %e %b %Y","%A, %e %b","-%A, %e %b %Y"],week:["Week from %A, %e %b %Y","%A, %e %b","-%A, %e %b %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},seriesSpecific:{line:{},spline:{},area:{},areaspline:{},arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5},hlc:{groupPixelWidth:5},heikinashi:{groupPixelWidth:10}},units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]]}}),i(a,"Extensions/DataGrouping/DataGroupingAxisComposition.js",[a["Extensions/DataGrouping/DataGroupingDefaults.js"],a["Core/Utilities.js"]],function(t,a){var i,o=a.addEvent,e=a.extend,n=a.merge,r=a.pick;function s(t){var a=this,i=a.series;i.forEach(function(t){t.groupPixelWidth=void 0}),i.forEach(function(i){i.groupPixelWidth=a.getGroupPixelWidth&&a.getGroupPixelWidth(),i.groupPixelWidth&&(i.hasProcessed=!0),i.applyGrouping(!!t.hasExtremesChanged)})}function p(){for(var a,i,o=this.series,e=o.length,n=0,s=!1;e--;)(i=o[e].options.dataGrouping)&&(n=Math.max(n,r(i.groupPixelWidth,t.common.groupPixelWidth)),a=(o[e].processedXData||o[e].data).length,(o[e].groupPixelWidth||a>this.chart.plotSizeX/n||a&&i.forced)&&(s=!0));return s?n:0}function u(){this.series.forEach(function(t){t.hasProcessed=!1})}function l(t,a){var o;if(a=r(a,!0),t||(t={forced:!1,units:null}),this instanceof i)for(o=this.series.length;o--;)this.series[o].update({dataGrouping:t},!1);else this.chart.options.series.forEach(function(a){a.dataGrouping="boolean"==typeof t?t:n(t,a.dataGrouping)});this.ordinal&&(this.ordinal.slope=void 0),a&&this.chart.redraw()}return{compose:function(t){i=t;var a=t.prototype;a.applyGrouping||(o(t,"afterSetScale",u),o(t,"postProcessData",s),e(a,{applyGrouping:s,getGroupPixelWidth:p,setDataGrouping:l}))}}}),i(a,"Extensions/DataGrouping/DataGroupingSeriesComposition.js",[a["Extensions/DataGrouping/ApproximationRegistry.js"],a["Extensions/DataGrouping/DataGroupingDefaults.js"],a["Core/Axis/DateTimeAxis.js"],a["Core/Defaults.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(t,a,i,o,e,n){var r=e.series.prototype,s=n.addEvent,p=n.defined,u=n.error,l=n.extend,h=n.isNumber,d=n.merge,g=n.pick,c=r.generatePoints;function f(t){var o,e,n,s,l=this.chart,d=this.options.dataGrouping,c=!1!==this.allowDG&&d&&g(d.enabled,l.options.isStock),f=this.reserveSpace(),m=this.currentDataGrouping,x=!1;c&&!this.requireSorting&&(this.requireSorting=x=!0);var D=!1==!(this.isCartesian&&!this.isDirty&&!this.xAxis.isDirty&&!this.yAxis.isDirty&&!t)||!c;if(x&&(this.requireSorting=!1),!D){this.destroyGroupedData();var G=d.groupAll?this.xData:this.processedXData,v=d.groupAll?this.yData:this.processedYData,y=l.plotSizeX,M=this.xAxis,A=M.options.ordinal,S=this.groupPixelWidth;if(S&&G&&G.length&&y){e=!0,this.isDirty=!0,this.points=null;var b,E=M.getExtremes(),P=E.min,j=E.max,C=A&&M.ordinal&&M.ordinal.getGroupIntervalFactor(P,j,this)||1,W=S*(j-P)/y*C,k=M.getTimeTicks(i.Additions.prototype.normalizeTimeTickInterval(W,d.units||a.units),Math.min(P,G[0]),Math.max(j,G[G.length-1]),M.options.startOfWeek,G,this.closestPointRange),H=r.groupData.apply(this,[G,v,k,d.approximation]),F=H.groupedXData,T=H.groupedYData,Y=0;for(d&&d.smoothed&&F.length&&(d.firstAnchor="firstPoint",d.anchor="middle",d.lastAnchor="lastPoint",u(32,!1,l,{"dataGrouping.smoothed":"use dataGrouping.anchor"})),o=1;o<k.length;o++)k.info.segmentStarts&&-1!==k.info.segmentStarts.indexOf(o)||(Y=Math.max(k[o]-k[o-1],Y));(n=k.info).gapSize=Y,this.closestPointRange=k.info.totalRange,this.groupMap=H.groupMap,this.currentDataGrouping=n,function(t,a,i){var o=t.options.dataGrouping,e=t.currentDataGrouping&&t.currentDataGrouping.gapSize;if(o&&t.xData&&e&&t.groupMap){var n=a.length-1,r=o.anchor,s=o.firstAnchor,p=o.lastAnchor,u=a.length-1,l=0;if(s&&t.xData[0]>=a[0]){l++;var d=t.groupMap[0].start,g=t.groupMap[0].length,c=void 0;h(d)&&h(g)&&(c=d+(g-1)),a[0]=({start:a[0],middle:a[0]+.5*e,end:a[0]+e,firstPoint:t.xData[0],lastPoint:c&&t.xData[c]})[s]}if(n>0&&p&&e&&a[n]>=i-e){u--;var f=t.groupMap[t.groupMap.length-1].start;a[n]=({start:a[n],middle:a[n]+.5*e,end:a[n]+e,firstPoint:f&&t.xData[f],lastPoint:t.xData[t.xData.length-1]})[p]}if(r&&"start"!==r)for(var m=e*({middle:.5,end:1})[r];u>=l;)a[u]+=m,u--}}(this,F,j),f&&(p((b=F)[0])&&h(M.min)&&h(M.dataMin)&&b[0]<M.min&&((!p(M.options.min)&&M.min<=M.dataMin||M.min===M.dataMin)&&(M.min=Math.min(b[0],M.min)),M.dataMin=Math.min(b[0],M.dataMin)),p(b[b.length-1])&&h(M.max)&&h(M.dataMax)&&b[b.length-1]>M.max&&((!p(M.options.max)&&h(M.dataMax)&&M.max>=M.dataMax||M.max===M.dataMax)&&(M.max=Math.max(b[b.length-1],M.max)),M.dataMax=Math.max(b[b.length-1],M.dataMax))),d.groupAll&&(this.allGroupedData=T,F=(s=this.cropData(F,T,M.min,M.max)).xData,T=s.yData,this.cropStart=s.start),this.processedXData=F,this.processedYData=T}else this.groupMap=null;this.hasGroupedData=e,this.preventGraphAnimation=(m&&m.totalRange)!==(n&&n.totalRange)}}function m(){this.groupedData&&(this.groupedData.forEach(function(t,a){t&&(this.groupedData[a]=t.destroy?t.destroy():null)},this),this.groupedData.length=0,delete this.allGroupedData)}function x(){c.apply(this),this.destroyGroupedData(),this.groupedData=this.hasGroupedData?this.points:null}function D(){return this.is("arearange")?"range":this.is("ohlc")?"ohlc":this.is("hlc")?"hlc":this.is("column")||this.options.cumulative?"sum":"average"}function G(a,i,o,e){var n,r,s,u=this,l=u.data,g=u.options&&u.options.data,c=[],f=[],m=[],x=a.length,D=!!i,G=[],v=u.pointArrayMap,y=v&&v.length,M=["x"].concat(v||["y"]),A=this.options.dataGrouping&&this.options.dataGrouping.groupAll,S=0,b=0,E="function"==typeof e?e:e&&t[e]?t[e]:t[u.getDGApproximation&&u.getDGApproximation()||"average"];if(y)for(var P=v.length;P--;)G.push([]);else G.push([]);for(var j=y||1,C=0;C<=x;C++)if(!(a[C]<o[0])){for(;void 0!==o[S+1]&&a[C]>=o[S+1]||C===x;){n=o[S],u.dataGroupInfo={start:A?b:u.cropStart+b,length:G[0].length,groupStart:n},s=E.apply(u,G),u.pointClass&&!p(u.dataGroupInfo.options)&&(u.dataGroupInfo.options=d(u.pointClass.prototype.optionsToObject.call({series:u},u.options.data[u.cropStart+b])),M.forEach(function(t){delete u.dataGroupInfo.options[t]})),void 0!==s&&(c.push(n),f.push(s),m.push(u.dataGroupInfo)),b=C;for(var W=0;W<j;W++)G[W].length=0,G[W].hasNulls=!1;if(S+=1,C===x)break}if(C===x)break;if(v)for(var k=u.options.dataGrouping&&u.options.dataGrouping.groupAll?C:u.cropStart+C,H=l&&l[k]||u.pointClass.prototype.applyOptions.apply({series:u},[g[k]]),F=void 0,W=0;W<y;W++)h(F=H[v[W]])?G[W].push(F):null===F&&(G[W].hasNulls=!0);else h(r=D?i[C]:null)?G[0].push(r):null===r&&(G[0].hasNulls=!0)}return{groupedXData:c,groupedYData:f,groupMap:m}}function v(t){var i=t.options,e=this.type,n=this.chart.options.plotOptions,r=this.useCommonDataGrouping&&a.common,s=a.seriesSpecific,p=o.defaultOptions.plotOptions[e].dataGrouping;if(n&&(s[e]||r)){var u=this.chart.rangeSelector;p||(p=d(a.common,s[e])),i.dataGrouping=d(r,p,n.series&&n.series.dataGrouping,n[e].dataGrouping,this.userOptions.dataGrouping,!i.isInternal&&u&&h(u.selected)&&u.buttonOptions[u.selected].dataGrouping)}}return{compose:function(t){var a=t.prototype;a.applyGrouping||(s(t.prototype.pointClass,"update",function(){if(this.dataGroup)return u(24,!1,this.series.chart),!1}),s(t,"afterSetOptions",v),s(t,"destroy",m),l(a,{applyGrouping:f,destroyGroupedData:m,generatePoints:x,getDGApproximation:D,groupData:G}))},groupData:G}}),i(a,"Extensions/DataGrouping/DataGrouping.js",[a["Extensions/DataGrouping/DataGroupingAxisComposition.js"],a["Extensions/DataGrouping/DataGroupingDefaults.js"],a["Extensions/DataGrouping/DataGroupingSeriesComposition.js"],a["Core/Templating.js"],a["Core/Globals.js"],a["Core/Utilities.js"]],function(t,a,i,o,e,n){var r=o.format,s=e.composed,p=n.addEvent,u=n.extend,l=n.isNumber,h=n.pick,d=n.pushUnique;function g(t){var i,o,e,n,s,p,d=this.chart,g=d.time,c=t.labelConfig,f=c.series,m=c.point,x=f.options,D=f.tooltipOptions,G=x.dataGrouping,v=f.xAxis,y=D.xDateFormat,M=D[t.isFooter?"footerFormat":"headerFormat"];if(v&&"datetime"===v.options.type&&G&&l(c.key)){e=f.currentDataGrouping,n=G.dateTimeLabelFormats||a.common.dateTimeLabelFormats,e?(s=n[e.unitName],1===e.count?y=s[0]:(y=s[1],o=s[2])):!y&&n&&v.dateTime&&(y=v.dateTime.getXDateFormat(c.x,D.dateTimeLabelFormats));var A=h(null===(i=f.groupMap)||void 0===i?void 0:i[m.index].groupStart,c.key),S=A+(null==e?void 0:e.totalRange)-1;p=g.dateFormat(y,A),o&&(p+=g.dateFormat(o,S)),f.chart.styledMode&&(M=this.styledModeFormat(M)),t.text=r(M,{point:u(c.point,{key:p}),series:f},d),t.preventDefault()}}return{compose:function(a,o,e){t.compose(a),i.compose(o),e&&d(s,"DataGrouping")&&p(e,"headerFormatter",g)},groupData:i.groupData}}),i(a,"masters/modules/datagrouping.src.js",[a["Core/Globals.js"],a["Extensions/DataGrouping/ApproximationDefaults.js"],a["Extensions/DataGrouping/ApproximationRegistry.js"],a["Extensions/DataGrouping/DataGrouping.js"]],function(t,a,i,o){return t.dataGrouping=t.dataGrouping||{},t.dataGrouping.approximationDefaults=t.dataGrouping.approximationDefaults||a,t.dataGrouping.approximations=t.dataGrouping.approximations||i,o.compose(t.Axis,t.Series,t.Tooltip),t})});