!/**
 * Highcharts JS v11.4.0 (2024-03-04)
 *
 * Boost module
 *
 * (c) 2010-2024 Highsoft AS
 * Author: Torstein Honsi
 *
 * License: www.highcharts.com/license
 */function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/boost-canvas",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function i(t,e,i,o){t.hasOwnProperty(e)||(t[e]=o.apply(null,i),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}i(e,"Extensions/Boost/Boostables.js",[],function(){return["area","areaspline","arearange","column","columnrange","bar","line","scatter","heatmap","bubble","treemap"]}),i(e,"Extensions/Boost/BoostableMap.js",[e["Extensions/Boost/Boostables.js"]],function(t){var e={};return t.forEach(function(t){e[t]=!0}),e}),i(e,"Extensions/Boost/BoostChart.js",[e["Extensions/Boost/BoostableMap.js"],e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e,i){var o=e.composed,s=i.addEvent,r=i.pick,n=i.pushUnique;function a(e){var i=e.series,o=e.boost=e.boost||{},s=e.options.boost||{},n=r(s.seriesThreshold,50);if(i.length>=n)return!0;if(1===i.length)return!1;var a=s.allowForce;if(void 0===a){a=!0;for(var l=0,h=e.xAxis;l<h.length;l++){var c=h[l];if(r(c.min,-1/0)>r(c.dataMin,-1/0)||r(c.max,1/0)<r(c.dataMax,1/0)){a=!1;break}}}if(void 0!==o.forceChartBoost){if(a)return o.forceChartBoost;o.forceChartBoost=void 0}for(var u,d=0,p=0,f=0;f<i.length;f++){var g=i[f];0!==(u=g.options).boostThreshold&&!1!==g.visible&&"heatmap"!==g.type&&(t[g.type]&&++d,function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];var i=-Number.MAX_VALUE;return t.forEach(function(t){if(null!=t&&void 0!==t.length&&t.length>0)return i=t.length,!0}),i}(g.processedXData,u.data,g.points)>=(u.boostThreshold||Number.MAX_VALUE)&&++p)}return o.forceChartBoost=a&&(d===i.length&&p===d||p>5),o.forceChartBoost}function l(t){function e(){t.boost&&t.boost.wgl&&a(t)&&t.boost.wgl.render(t)}s(t,"predraw",function(){var e,i;t.boost=t.boost||{},t.boost.forceChartBoost=void 0,t.boosted=!1,t.axes.some(function(t){return t.isPanning})||null===(i=(e=t.boost).clear)||void 0===i||i.call(e),t.boost.canvas&&t.boost.wgl&&a(t)&&t.boost.wgl.allocateBuffer(t),t.boost.markerGroup&&t.xAxis&&t.xAxis.length>0&&t.yAxis&&t.yAxis.length>0&&t.boost.markerGroup.translate(t.xAxis[0].pos,t.yAxis[0].pos)}),s(t,"load",e,{order:-1}),s(t,"redraw",e);var i=-1,o=-1;s(t.pointer,"afterGetHoverData",function(){var e=t.hoverSeries;if(t.boost=t.boost||{},t.boost.markerGroup&&e){var s=t.inverted?e.yAxis:e.xAxis,r=t.inverted?e.xAxis:e.yAxis;(s&&s.pos!==i||r&&r.pos!==o)&&(t.boost.markerGroup.translate(s.pos,r.pos),i=s.pos,o=r.pos)}})}return{compose:function(t,e){return e&&n(o,"Boost.Chart")&&t.prototype.callbacks.push(l),t},getBoostClipRect:function(t,e){var i={x:t.plotLeft,y:t.plotTop,width:t.plotWidth,height:t.navigator?t.navigator.top+t.navigator.height-t.plotTop:t.plotHeight};if(e.getClipBox){var o=e.xAxis,s=e.yAxis;if(i=e.getClipBox(),t.inverted){var r=i.width;i.width=i.height,i.height=r,i.x=s.pos,i.y=o.pos}else i.x=o.pos,i.y=s.pos}if(e===t){var n=t.inverted?t.xAxis:t.yAxis;n.length<=1&&(i.y=Math.min(n[0].pos,i.y),i.height=n[0].pos-t.plotTop+n[0].len)}return i},isChartSeriesBoosting:a}}),i(e,"Extensions/Boost/WGLDrawMode.js",[],function(){return{area:"LINES",arearange:"LINES",areaspline:"LINES",column:"LINES",columnrange:"LINES",bar:"LINES",line:"LINE_STRIP",scatter:"POINTS",heatmap:"TRIANGLES",treemap:"TRIANGLES",bubble:"POINTS"}}),i(e,"Extensions/Boost/WGLShader.js",[e["Core/Utilities.js"]],function(t){var e=t.clamp,i=t.error,o=t.pick;return function(){function t(t){if(this.errors=[],this.uLocations={},this.gl=t,t&&!this.createShader())return}return t.prototype.bind=function(){this.gl&&this.shaderProgram&&this.gl.useProgram(this.shaderProgram)},t.prototype.createShader=function(){var t=this,e=this.stringToProgram("#version 100\n#define LN10 2.302585092994046\nprecision highp float;\nattribute vec4 aVertexPosition;\nattribute vec4 aColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform mat4 uPMatrix;\nuniform float pSize;\nuniform float translatedThreshold;\nuniform bool hasThreshold;\nuniform bool skipTranslation;\nuniform float xAxisTrans;\nuniform float xAxisMin;\nuniform float xAxisMinPad;\nuniform float xAxisPointRange;\nuniform float xAxisLen;\nuniform bool  xAxisPostTranslate;\nuniform float xAxisOrdinalSlope;\nuniform float xAxisOrdinalOffset;\nuniform float xAxisPos;\nuniform bool  xAxisCVSCoord;\nuniform bool  xAxisIsLog;\nuniform bool  xAxisReversed;\nuniform float yAxisTrans;\nuniform float yAxisMin;\nuniform float yAxisMinPad;\nuniform float yAxisPointRange;\nuniform float yAxisLen;\nuniform bool  yAxisPostTranslate;\nuniform float yAxisOrdinalSlope;\nuniform float yAxisOrdinalOffset;\nuniform float yAxisPos;\nuniform bool  yAxisCVSCoord;\nuniform bool  yAxisIsLog;\nuniform bool  yAxisReversed;\nuniform bool  isBubble;\nuniform bool  bubbleSizeByArea;\nuniform float bubbleZMin;\nuniform float bubbleZMax;\nuniform float bubbleZThreshold;\nuniform float bubbleMinSize;\nuniform float bubbleMaxSize;\nuniform bool  bubbleSizeAbs;\nuniform bool  isInverted;\nfloat bubbleRadius(){\nfloat value = aVertexPosition.w;\nfloat zMax = bubbleZMax;\nfloat zMin = bubbleZMin;\nfloat radius = 0.0;\nfloat pos = 0.0;\nfloat zRange = zMax - zMin;\nif (bubbleSizeAbs){\nvalue = value - bubbleZThreshold;\nzMax = max(zMax - bubbleZThreshold, zMin - bubbleZThreshold);\nzMin = 0.0;\n}\nif (value < zMin){\nradius = bubbleZMin / 2.0 - 1.0;\n} else {\npos = zRange > 0.0 ? (value - zMin) / zRange : 0.5;\nif (bubbleSizeByArea && pos > 0.0){\npos = sqrt(pos);\n}\nradius = ceil(bubbleMinSize + pos * (bubbleMaxSize - bubbleMinSize)) / 2.0;\n}\nreturn radius * 2.0;\n}\nfloat translate(float val,\nfloat pointPlacement,\nfloat localA,\nfloat localMin,\nfloat minPixelPadding,\nfloat pointRange,\nfloat len,\nbool  cvsCoord,\nbool  isLog,\nbool  reversed\n){\nfloat sign = 1.0;\nfloat cvsOffset = 0.0;\nif (cvsCoord) {\nsign *= -1.0;\ncvsOffset = len;\n}\nif (isLog) {\nval = log(val) / LN10;\n}\nif (reversed) {\nsign *= -1.0;\ncvsOffset -= sign * len;\n}\nreturn sign * (val - localMin) * localA + cvsOffset + \n(sign * minPixelPadding);\n}\nfloat xToPixels(float value) {\nif (skipTranslation){\nreturn value;// + xAxisPos;\n}\nreturn translate(value, 0.0, xAxisTrans, xAxisMin, xAxisMinPad, xAxisPointRange, xAxisLen, xAxisCVSCoord, xAxisIsLog, xAxisReversed);// + xAxisPos;\n}\nfloat yToPixels(float value, float checkTreshold) {\nfloat v;\nif (skipTranslation){\nv = value;// + yAxisPos;\n} else {\nv = translate(value, 0.0, yAxisTrans, yAxisMin, yAxisMinPad, yAxisPointRange, yAxisLen, yAxisCVSCoord, yAxisIsLog, yAxisReversed);// + yAxisPos;\nif (v > yAxisLen) {\nv = yAxisLen;\n}\n}\nif (checkTreshold > 0.0 && hasThreshold) {\nv = min(v, translatedThreshold);\n}\nreturn v;\n}\nvoid main(void) {\nif (isBubble){\ngl_PointSize = bubbleRadius();\n} else {\ngl_PointSize = pSize;\n}\nvColor = aColor;\nif (skipTranslation && isInverted) {\ngl_Position = uPMatrix * vec4(aVertexPosition.y + yAxisPos, aVertexPosition.x + xAxisPos, 0.0, 1.0);\n} else if (isInverted) {\ngl_Position = uPMatrix * vec4(yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, xToPixels(aVertexPosition.x) + xAxisPos, 0.0, 1.0);\n} else {\ngl_Position = uPMatrix * vec4(xToPixels(aVertexPosition.x) + xAxisPos, yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, 0.0, 1.0);\n}\n}","vertex"),i=this.stringToProgram("precision highp float;\nuniform vec4 fillColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform sampler2D uSampler;\nuniform bool isCircle;\nuniform bool hasColor;\nvoid main(void) {\nvec4 col = fillColor;\nvec4 tcol = texture2D(uSampler, gl_PointCoord.st);\nif (hasColor) {\ncol = vColor;\n}\nif (isCircle) {\ncol *= tcol;\nif (tcol.r < 0.0) {\ndiscard;\n} else {\ngl_FragColor = col;\n}\n} else {\ngl_FragColor = col;\n}\n}","fragment"),o=function(e){return t.gl.getUniformLocation(t.shaderProgram,e)};return e&&i?(this.shaderProgram=this.gl.createProgram(),this.gl.attachShader(this.shaderProgram,e),this.gl.attachShader(this.shaderProgram,i),this.gl.linkProgram(this.shaderProgram),this.gl.getProgramParameter(this.shaderProgram,this.gl.LINK_STATUS))?(this.gl.useProgram(this.shaderProgram),this.gl.bindAttribLocation(this.shaderProgram,0,"aVertexPosition"),this.pUniform=o("uPMatrix"),this.psUniform=o("pSize"),this.fcUniform=o("fillColor"),this.isBubbleUniform=o("isBubble"),this.bubbleSizeAbsUniform=o("bubbleSizeAbs"),this.bubbleSizeAreaUniform=o("bubbleSizeByArea"),this.uSamplerUniform=o("uSampler"),this.skipTranslationUniform=o("skipTranslation"),this.isCircleUniform=o("isCircle"),this.isInverted=o("isInverted"),!0):(this.errors.push(this.gl.getProgramInfoLog(this.shaderProgram)),this.handleErrors(),this.shaderProgram=!1,!1):(this.shaderProgram=!1,this.handleErrors(),!1)},t.prototype.handleErrors=function(){this.errors.length&&i("[highcharts boost] shader error - "+this.errors.join("\n"))},t.prototype.stringToProgram=function(t,e){var i=this.gl.createShader("vertex"===e?this.gl.VERTEX_SHADER:this.gl.FRAGMENT_SHADER);return(this.gl.shaderSource(i,t),this.gl.compileShader(i),this.gl.getShaderParameter(i,this.gl.COMPILE_STATUS))?i:(this.errors.push("when compiling "+e+" shader:\n"+this.gl.getShaderInfoLog(i)),!1)},t.prototype.destroy=function(){this.gl&&this.shaderProgram&&(this.gl.deleteProgram(this.shaderProgram),this.shaderProgram=!1)},t.prototype.fillColorUniform=function(){return this.fcUniform},t.prototype.getProgram=function(){return this.shaderProgram},t.prototype.pointSizeUniform=function(){return this.psUniform},t.prototype.perspectiveUniform=function(){return this.pUniform},t.prototype.reset=function(){this.gl&&this.shaderProgram&&(this.gl.uniform1i(this.isBubbleUniform,0),this.gl.uniform1i(this.isCircleUniform,0))},t.prototype.setBubbleUniforms=function(t,i,s,r){void 0===r&&(r=1);var n=t.options,a=Number.MAX_VALUE,l=-Number.MAX_VALUE;if(this.gl&&this.shaderProgram&&t.is("bubble")){var h=t.getPxExtremes();a=o(n.zMin,e(i,!1===n.displayNegative?n.zThreshold:-Number.MAX_VALUE,a)),l=o(n.zMax,Math.max(l,s)),this.gl.uniform1i(this.isBubbleUniform,1),this.gl.uniform1i(this.isCircleUniform,1),this.gl.uniform1i(this.bubbleSizeAreaUniform,"width"!==t.options.sizeBy),this.gl.uniform1i(this.bubbleSizeAbsUniform,t.options.sizeByAbsoluteValue),this.setUniform("bubbleMinSize",h.minPxSize*r),this.setUniform("bubbleMaxSize",h.maxPxSize*r),this.setUniform("bubbleZMin",a),this.setUniform("bubbleZMax",l),this.setUniform("bubbleZThreshold",t.options.zThreshold)}},t.prototype.setColor=function(t){this.gl&&this.shaderProgram&&this.gl.uniform4f(this.fcUniform,t[0]/255,t[1]/255,t[2]/255,t[3])},t.prototype.setDrawAsCircle=function(t){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.isCircleUniform,t?1:0)},t.prototype.setInverted=function(t){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.isInverted,t)},t.prototype.setPMatrix=function(t){this.gl&&this.shaderProgram&&this.gl.uniformMatrix4fv(this.pUniform,!1,t)},t.prototype.setPointSize=function(t){this.gl&&this.shaderProgram&&this.gl.uniform1f(this.psUniform,t)},t.prototype.setSkipTranslation=function(t){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.skipTranslationUniform,!0===t?1:0)},t.prototype.setTexture=function(t){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.uSamplerUniform,t)},t.prototype.setUniform=function(t,e){if(this.gl&&this.shaderProgram){var i=this.uLocations[t]=this.uLocations[t]||this.gl.getUniformLocation(this.shaderProgram,t);this.gl.uniform1f(i,e)}},t}()}),i(e,"Extensions/Boost/WGLVertexBuffer.js",[],function(){return function(){function t(t,e,i){this.buffer=!1,this.iterator=0,this.preAllocated=!1,this.vertAttribute=!1,this.components=i||2,this.dataComponents=i,this.gl=t,this.shader=e}return t.prototype.allocate=function(t){this.iterator=-1,this.preAllocated=new Float32Array(4*t)},t.prototype.bind=function(){if(!this.buffer)return!1;this.gl.vertexAttribPointer(this.vertAttribute,this.components,this.gl.FLOAT,!1,0,0)},t.prototype.build=function(t,e,i){var o;return(this.data=t||[],this.data&&0!==this.data.length||this.preAllocated)?(this.components=i||this.components,this.buffer&&this.gl.deleteBuffer(this.buffer),this.preAllocated||(o=new Float32Array(this.data)),this.buffer=this.gl.createBuffer(),this.gl.bindBuffer(this.gl.ARRAY_BUFFER,this.buffer),this.gl.bufferData(this.gl.ARRAY_BUFFER,this.preAllocated||o,this.gl.STATIC_DRAW),this.vertAttribute=this.gl.getAttribLocation(this.shader.getProgram(),e),this.gl.enableVertexAttribArray(this.vertAttribute),o=!1,!0):(this.destroy(),!1)},t.prototype.destroy=function(){this.buffer&&(this.gl.deleteBuffer(this.buffer),this.buffer=!1,this.vertAttribute=!1),this.iterator=0,this.components=this.dataComponents||2,this.data=[]},t.prototype.push=function(t,e,i,o){this.preAllocated&&(this.preAllocated[++this.iterator]=t,this.preAllocated[++this.iterator]=e,this.preAllocated[++this.iterator]=i,this.preAllocated[++this.iterator]=o)},t.prototype.render=function(t,e,i){var o=this.preAllocated?this.preAllocated.length:this.data.length;return!!this.buffer&&!!o&&((!t||t>o||t<0)&&(t=0),(!e||e>o)&&(e=o),!(t>=e)&&(i=i||"POINTS",this.gl.drawArrays(this.gl[i],t/this.components,(e-t)/this.components),!0))},t}()}),i(e,"Extensions/Boost/WGLRenderer.js",[e["Core/Color/Color.js"],e["Core/Globals.js"],e["Core/Utilities.js"],e["Extensions/Boost/WGLDrawMode.js"],e["Extensions/Boost/WGLShader.js"],e["Extensions/Boost/WGLVertexBuffer.js"]],function(t,e,i,o,s,r){var n=t.parse,a=e.doc,l=e.win,h=i.isNumber,c=i.isObject,u=i.merge,d=i.objectEach,p=i.pick,f={column:!0,columnrange:!0,bar:!0,area:!0,areaspline:!0,arearange:!0},g={scatter:!0,bubble:!0},m=["webgl","experimental-webgl","moz-webgl","webkit-3d"];return function(){function i(t){this.data=[],this.height=0,this.isInited=!1,this.markerData=[],this.series=[],this.textureHandles={},this.width=0,this.postRenderCallback=t,this.settings={pointSize:1,lineWidth:1,fillColor:"#AA00AA",useAlpha:!0,usePreallocated:!1,useGPUTranslations:!1,debug:{timeRendering:!1,timeSeriesProcessing:!1,timeSetup:!1,timeBufferCopy:!1,timeKDTree:!1,showSkipSummary:!1}}}return i.orthoMatrix=function(t,e){return[2/t,0,0,0,0,-(2/e),0,0,0,0,-2,0,-1,1,-1,1]},i.seriesPointCount=function(t){var e,i,o;return t.boosted?(e=!!t.options.stacking,i=t.xData||t.options.xData||t.processedXData,o=(e?t.data:i||t.options.data).length,"treemap"===t.type?o*=12:"heatmap"===t.type?o*=6:f[t.type]&&(o*=2),o):0},i.prototype.getPixelRatio=function(){return this.settings.pixelRatio||l.devicePixelRatio||1},i.prototype.setOptions=function(t){"pixelRatio"in t||(t.pixelRatio=1),u(!0,this.settings,t)},i.prototype.allocateBuffer=function(t){var e=this.vbuffer,o=0;this.settings.usePreallocated&&(t.series.forEach(function(t){t.boosted&&(o+=i.seriesPointCount(t))}),e&&e.allocate(o))},i.prototype.allocateBufferForSingleSeries=function(t){var e=this.vbuffer,o=0;this.settings.usePreallocated&&(t.boosted&&(o=i.seriesPointCount(t)),e&&e.allocate(o))},i.prototype.clear=function(){var t=this.gl;t&&t.clear(t.COLOR_BUFFER_BIT|t.DEPTH_BUFFER_BIT)},i.prototype.pushSeriesData=function(t,e){var i,o,s,r,a,l,h,u,d=this,p=this.data,g=this.settings,m=this.vbuffer,b=t.pointArrayMap&&"low,high"===t.pointArrayMap.join(","),x=t.chart,v=t.options,A=t.sorted,y=t.xAxis,P=t.yAxis,T=!!v.stacking,E=v.data,S=t.xAxis.getExtremes(),C=S.min-(t.xAxis.minPointOffset||0),M=S.max+(t.xAxis.minPointOffset||0),U=t.yAxis.getExtremes(),R=U.min-(t.yAxis.minPointOffset||0),k=U.max+(t.yAxis.minPointOffset||0),w=t.xData||v.xData||t.processedXData,D=t.yData||v.yData||t.processedYData,B=t.zData||v.zData||t.processedZData,L=!w||0===w.length,N=v.connectNulls,_=t.points||!1,z=T?t.data:w||E,I={x:Number.MAX_VALUE,y:0},G={x:-Number.MAX_VALUE,y:0},O=void 0===x.index,X=f[t.type],V=v.zoneAxis||"y",j=v.zones||!1,F=v.threshold,Y=this.getPixelRatio(),H=t.chart.plotWidth,W=!1,K=!1,Z=0,q=!1,Q=-1,J=!1,$=!1,tt=!1,te=!1,ti=!1,to=!1,ts=!0,tr=!0,tn=!1,ta=!1,tl=0;if(!v.boostData||!(v.boostData.length>0)){v.gapSize&&(ta="value"!==v.gapUnit?v.gapSize*t.closestPointRange:v.gapSize),j&&(u=[],j.forEach(function(t,e){if(t.color){var i=n(t.color).rgba;i[0]/=255,i[1]/=255,i[2]/=255,u[e]=i,tn||void 0!==t.value||(tn=i)}}),tn||(tn=n(t.pointAttribs&&t.pointAttribs().fill||t.color).rgba,tn[0]/=255,tn[1]/=255,tn[2]/=255)),x.inverted&&(H=t.chart.plotHeight),t.closestPointRangePx=Number.MAX_VALUE;var th=function(t){t&&(e.colorData.push(t[0]),e.colorData.push(t[1]),e.colorData.push(t[2]),e.colorData.push(t[3]))},tc=function(t,i,o,s,r){void 0===s&&(s=1),th(r),1!==Y&&(!g.useGPUTranslations||e.skipTranslation)&&(t*=Y,i*=Y,s*=Y),g.usePreallocated&&m?(m.push(t,i,o?1:0,s),tl+=4):(p.push(t),p.push(i),p.push(o?Y:0),p.push(s))},tu=function(){e.segments.length&&(e.segments[e.segments.length-1].to=p.length||tl)},td=function(){e.segments.length&&e.segments[e.segments.length-1].from===(p.length||tl)||(tu(),e.segments.push({from:p.length||tl}))},tp=function(t,e,i,o,s){th(s),tc(t+i,e),th(s),tc(t,e),th(s),tc(t,e+o),th(s),tc(t,e+o),th(s),tc(t+i,e+o),th(s),tc(t+i,e)};if(td(),_&&_.length>0){e.skipTranslation=!0,e.drawMode="TRIANGLES",_[0].node&&_[0].node.levelDynamic&&_.sort(function(t,e){if(t.node){if(t.node.levelDynamic>e.node.levelDynamic)return 1;if(t.node.levelDynamic<e.node.levelDynamic)return -1}return 0}),_.forEach(function(e){var i,s,r=e.plotY;if(void 0!==r&&!isNaN(r)&&null!==e.y&&e.shapeArgs){var a=e.shapeArgs,l=a.x,h=void 0===l?0:l,c=a.y,u=void 0===c?0:c,d=a.width,p=void 0===d?0:d,f=a.height,g=void 0===f?0:f;i=(s=x.styledMode?e.series.colorAttribs(e):s=e.series.pointAttribs(e))["stroke-width"]||0,ti=n(s.fill).rgba,ti[0]/=255,ti[1]/=255,ti[2]/=255,t.is("treemap")&&(i=i||1,o=n(s.stroke).rgba,o[0]/=255,o[1]/=255,o[2]/=255,tp(h,u,p,g,o),i/=2),t.is("heatmap")&&x.inverted&&(h=y.len-h,u=P.len-u,p=-p,g=-g),tp(h+i,u+i,p-2*i,g-2*i,ti)}}),tu();return}for(;Q<z.length-1&&"break"!==function(){if(void 0===(a=z[++Q]))return"continue";if(O)return"break";var o,d=E&&E[Q];return(!L&&c(d,!0)&&d.color&&(ti=n(d.color).rgba,ti[0]/=255,ti[1]/=255,ti[2]/=255),L?(s=a[0],r=a[1],z[Q+1]&&($=z[Q+1][0]),z[Q-1]&&(J=z[Q-1][0]),a.length>=3&&(l=a[2],a[2]>e.zMax&&(e.zMax=a[2]),a[2]<e.zMin&&(e.zMin=a[2]))):(s=a,r=D[Q],z[Q+1]&&($=z[Q+1]),z[Q-1]&&(J=z[Q-1]),B&&B.length&&(l=B[Q],B[Q]>e.zMax&&(e.zMax=B[Q]),B[Q]<e.zMin&&(e.zMin=B[Q]))),N||null!==s&&null!==r)?($&&$>=C&&$<=M&&(tt=!0),J&&J>=C&&J<=M&&(te=!0),b?(L&&(r=a.slice(1,3)),h=r[0],r=r[1]):T&&(s=a.x,h=(r=a.stackY)-a.y),null!=R&&null!=k&&(ts=r>=R&&r<=k),s>M&&G.x<M&&(G.x=s,G.y=r),s<C&&I.x>C&&(I.x=s,I.y=r),null===r&&N)?"continue":null!==r&&(ts||tt||te)?(A&&($>=C||s>=C)&&(J<=M||s<=M)&&(to=!0),to||tt||te)?(ta&&s-J>ta&&td(),j&&(j.some(function(t,e){var i=j[e-1];return"x"===V?void 0!==t.value&&s<=t.value&&(u[e]&&(!i||s>=i.value)&&(o=u[e]),!0):void 0!==t.value&&r<=t.value&&(u[e]&&(!i||r>=i.value)&&(o=u[e]),!0)}),ti=o||tn||ti),!g.useGPUTranslations&&(e.skipTranslation=!0,s=y.toPixels(s,!0),r=P.toPixels(r,!0),s>H&&"POINTS"===e.drawMode))?"continue":(e.hasMarkers&&to&&!1!==W&&(t.closestPointRangePx=Math.min(t.closestPointRangePx,Math.abs(s-W))),!g.useGPUTranslations&&!g.usePreallocated&&W&&1>Math.abs(s-W)&&K&&1>Math.abs(r-K))?(g.debug.showSkipSummary&&++Z,"continue"):void(X&&(i=h,(!1===h||void 0===h)&&(i=r<0?r:0),(b||T)&&!P.logarithmic||(i=Math.max(null===F?R:F,R)),g.useGPUTranslations||(i=P.toPixels(i,!0)),tc(s,i,0,0,ti)),v.step&&!tr&&tc(s,K,0,2,ti),tc(s,r,0,"bubble"===t.type?l||1:2,ti),W=s,K=r,q=!0,tr=!1):"continue":(td(),"continue"):(td(),"continue")}(););g.debug.showSkipSummary&&console.log("skipped points:",Z);var tf=function(t,i){if(g.useGPUTranslations||(e.skipTranslation=!0,t.x=y.toPixels(t.x,!0),t.y=P.toPixels(t.y,!0)),i){d.data=[t.x,t.y,0,2].concat(d.data);return}tc(t.x,t.y,0,2)};!q&&!1!==N&&"line_strip"===t.drawMode&&(I.x<Number.MAX_VALUE&&tf(I,!0),G.x>-Number.MAX_VALUE&&tf(G)),tu()}},i.prototype.pushSeries=function(t){var e=this.markerData,i=this.series,s=this.settings;i.length>0&&i[i.length-1].hasMarkers&&(i[i.length-1].markerTo=e.length),s.debug.timeSeriesProcessing&&console.time("building "+t.type+" series");var r={segments:[],markerFrom:e.length,colorData:[],series:t,zMin:Number.MAX_VALUE,zMax:-Number.MAX_VALUE,hasMarkers:!!t.options.marker&&!1!==t.options.marker.enabled,showMarkers:!0,drawMode:o[t.type]||"LINE_STRIP"};t.index>=i.length?i.push(r):i[t.index]=r,this.pushSeriesData(t,r),s.debug.timeSeriesProcessing&&console.timeEnd("building "+t.type+" series")},i.prototype.flush=function(){var t=this.vbuffer;this.data=[],this.markerData=[],this.series=[],t&&t.destroy()},i.prototype.setXAxis=function(t){var e=this.shader;if(e){var i=this.getPixelRatio();e.setUniform("xAxisTrans",t.transA*i),e.setUniform("xAxisMin",t.min),e.setUniform("xAxisMinPad",t.minPixelPadding*i),e.setUniform("xAxisPointRange",t.pointRange),e.setUniform("xAxisLen",t.len*i),e.setUniform("xAxisPos",t.pos*i),e.setUniform("xAxisCVSCoord",!t.horiz),e.setUniform("xAxisIsLog",!!t.logarithmic),e.setUniform("xAxisReversed",!!t.reversed)}},i.prototype.setYAxis=function(t){var e=this.shader;if(e){var i=this.getPixelRatio();e.setUniform("yAxisTrans",t.transA*i),e.setUniform("yAxisMin",t.min),e.setUniform("yAxisMinPad",t.minPixelPadding*i),e.setUniform("yAxisPointRange",t.pointRange),e.setUniform("yAxisLen",t.len*i),e.setUniform("yAxisPos",t.pos*i),e.setUniform("yAxisCVSCoord",!t.horiz),e.setUniform("yAxisIsLog",!!t.logarithmic),e.setUniform("yAxisReversed",!!t.reversed)}},i.prototype.setThreshold=function(t,e){var i=this.shader;i&&(i.setUniform("hasThreshold",t),i.setUniform("translatedThreshold",e))},i.prototype.renderChart=function(o){var s=this,a=this.gl,l=this.settings,c=this.shader,u=this.vbuffer,d=this.getPixelRatio();if(!o)return!1;this.width=o.chartWidth*d,this.height=o.chartHeight*d;var f=this.height,m=this.width;if(!a||!c||!m||!f)return!1;l.debug.timeRendering&&console.time("gl rendering"),a.canvas.width=m,a.canvas.height=f,c.bind(),a.viewport(0,0,m,f),c.setPMatrix(i.orthoMatrix(m,f)),l.lineWidth>1&&!e.isMS&&a.lineWidth(l.lineWidth),u&&(u.build(this.data,"aVertexPosition",4),u.bind()),c.setInverted(o.inverted),this.series.forEach(function(e,i){var f,m,b,x=e.series.options,v=x.marker,A=void 0!==x.lineWidth?x.lineWidth:1,y=x.threshold,P=h(y),T=e.series.yAxis.getThreshold(y),E=p(x.marker?x.marker.enabled:null,!!e.series.xAxis.isRadial||null,e.series.closestPointRangePx>2*((x.marker?x.marker.radius:10)||10)),S=s.textureHandles[v&&v.symbol||e.series.symbol]||s.textureHandles.circle,C=[];if(0!==e.segments.length&&e.segments[0].from!==e.segments[0].to&&(S.isReady&&(a.bindTexture(a.TEXTURE_2D,S.handle),c.setTexture(S.handle)),o.styledMode?b=e.series.markerGroup&&e.series.markerGroup.getStyle("fill"):(b="POINTS"===e.drawMode&&e.series.pointAttribs&&e.series.pointAttribs().fill||e.series.color,x.colorByPoint&&(b=e.series.chart.options.colors[i])),e.series.fillOpacity&&x.fillOpacity&&(b=new t(b).setOpacity(p(x.fillOpacity,1)).get()),C=n(b).rgba,l.useAlpha||(C[3]=1),"LINES"===e.drawMode&&l.useAlpha&&C[3]<1&&(C[3]/=10),"add"===x.boostBlending?(a.blendFunc(a.SRC_ALPHA,a.ONE),a.blendEquation(a.FUNC_ADD)):"mult"===x.boostBlending||"multiply"===x.boostBlending?a.blendFunc(a.DST_COLOR,a.ZERO):"darken"===x.boostBlending?(a.blendFunc(a.ONE,a.ONE),a.blendEquation(a.FUNC_MIN)):a.blendFuncSeparate(a.SRC_ALPHA,a.ONE_MINUS_SRC_ALPHA,a.ONE,a.ONE_MINUS_SRC_ALPHA),c.reset(),e.colorData.length>0?(c.setUniform("hasColor",1),(m=new r(a,c)).build(Array(e.segments[0].from).concat(e.colorData),"aColor",4),m.bind()):(c.setUniform("hasColor",0),a.disableVertexAttribArray(a.getAttribLocation(c.getProgram(),"aColor"))),c.setColor(C),s.setXAxis(e.series.xAxis),s.setYAxis(e.series.yAxis),s.setThreshold(P,T),"POINTS"===e.drawMode&&c.setPointSize(2*p(x.marker&&x.marker.radius,.5)*d),c.setSkipTranslation(e.skipTranslation),"bubble"===e.series.type&&c.setBubbleUniforms(e.series,e.zMin,e.zMax,d),c.setDrawAsCircle(g[e.series.type]||!1),u)){if(A>0||"LINE_STRIP"!==e.drawMode)for(f=0;f<e.segments.length;f++)u.render(e.segments[f].from,e.segments[f].to,e.drawMode);if(e.hasMarkers&&E)for(c.setPointSize(2*p(x.marker&&x.marker.radius,5)*d),c.setDrawAsCircle(!0),f=0;f<e.segments.length;f++)u.render(e.segments[f].from,e.segments[f].to,"POINTS")}}),l.debug.timeRendering&&console.timeEnd("gl rendering"),this.postRenderCallback&&this.postRenderCallback(this),this.flush()},i.prototype.render=function(t){var e=this;if(this.clear(),t.renderer.forExport)return this.renderChart(t);this.isInited?this.renderChart(t):setTimeout(function(){e.render(t)},1)},i.prototype.setSize=function(t,e){var o=this.shader;o&&(this.width!==t||this.height!==e)&&(this.width=t,this.height=e,o.bind(),o.setPMatrix(i.orthoMatrix(t,e)))},i.prototype.init=function(t,e){var i=this,o=this.settings;if(this.isInited=!1,!t)return!1;o.debug.timeSetup&&console.time("gl setup");for(var n=0;n<m.length&&(this.gl=t.getContext(m[n],{}),!this.gl);++n);var l=this.gl;if(!l)return!1;e||this.flush(),l.enable(l.BLEND),l.blendFunc(l.SRC_ALPHA,l.ONE_MINUS_SRC_ALPHA),l.disable(l.DEPTH_TEST),l.depthFunc(l.LESS);var h=this.shader=new s(l);if(!h)return!1;this.vbuffer=new r(l,h);var c=function(t,e){var o={isReady:!1,texture:a.createElement("canvas"),handle:l.createTexture()},s=o.texture.getContext("2d");i.textureHandles[t]=o,o.texture.width=512,o.texture.height=512,s.mozImageSmoothingEnabled=!1,s.webkitImageSmoothingEnabled=!1,s.msImageSmoothingEnabled=!1,s.imageSmoothingEnabled=!1,s.strokeStyle="rgba(255, 255, 255, 0)",s.fillStyle="#FFF",e(s);try{l.activeTexture(l.TEXTURE0),l.bindTexture(l.TEXTURE_2D,o.handle),l.texImage2D(l.TEXTURE_2D,0,l.RGBA,l.RGBA,l.UNSIGNED_BYTE,o.texture),l.texParameteri(l.TEXTURE_2D,l.TEXTURE_WRAP_S,l.CLAMP_TO_EDGE),l.texParameteri(l.TEXTURE_2D,l.TEXTURE_WRAP_T,l.CLAMP_TO_EDGE),l.texParameteri(l.TEXTURE_2D,l.TEXTURE_MAG_FILTER,l.LINEAR),l.texParameteri(l.TEXTURE_2D,l.TEXTURE_MIN_FILTER,l.LINEAR),l.bindTexture(l.TEXTURE_2D,null),o.isReady=!0}catch(t){}};return c("circle",function(t){t.beginPath(),t.arc(256,256,256,0,2*Math.PI),t.stroke(),t.fill()}),c("square",function(t){t.fillRect(0,0,512,512)}),c("diamond",function(t){t.beginPath(),t.moveTo(256,0),t.lineTo(512,256),t.lineTo(256,512),t.lineTo(0,256),t.lineTo(256,0),t.fill()}),c("triangle",function(t){t.beginPath(),t.moveTo(0,512),t.lineTo(256,0),t.lineTo(512,512),t.lineTo(0,512),t.fill()}),c("triangle-down",function(t){t.beginPath(),t.moveTo(0,0),t.lineTo(256,512),t.lineTo(512,0),t.lineTo(0,0),t.fill()}),this.isInited=!0,o.debug.timeSetup&&console.timeEnd("gl setup"),!0},i.prototype.destroy=function(){var t=this.gl,e=this.shader,i=this.vbuffer;this.flush(),i&&i.destroy(),e&&e.destroy(),t&&(d(this.textureHandles,function(e){e.handle&&t.deleteTexture(e.handle)}),t.canvas.width=1,t.canvas.height=1)},i}()}),i(e,"Extensions/Boost/BoostSeries.js",[e["Extensions/Boost/BoostableMap.js"],e["Extensions/Boost/Boostables.js"],e["Extensions/Boost/BoostChart.js"],e["Core/Defaults.js"],e["Core/Globals.js"],e["Core/Utilities.js"],e["Extensions/Boost/WGLRenderer.js"]],function(t,e,i,o,s,r,n){var a,l,h=i.getBoostClipRect,c=i.isChartSeriesBoosting,u=o.getOptions,d=s.composed,p=s.doc,f=s.noop,g=s.win,m=r.addEvent,b=r.destroyObjectProperties,x=r.error,v=r.extend,A=r.fireEvent,y=r.isArray,P=r.isNumber,T=r.pick,E=r.pushUnique,S=r.wrap,C=r.defined;function M(t,e){var i=e.boost;t&&i&&i.target&&i.canvas&&!c(e.chart)&&t.allocateBufferForSingleSeries(e)}function U(t){return T(t&&t.options&&t.options.boost&&t.options.boost.enabled,!0)}function R(t,e){var i=t.constructor,o=t.seriesGroup||e.group,s=t.chartWidth,r=t.chartHeight,a=t,u="undefined"!=typeof SVGForeignObjectElement,d=(a=c(t)?t:e).boost=a.boost||{};if(u=!1,l||(l=p.createElement("canvas")),!d.target&&(d.canvas=l,t.renderer.forExport||!u?(a.renderTarget=d.target=t.renderer.image("",0,0,s,r).addClass("highcharts-boost-canvas").add(o),d.clear=function(){d.target.attr({href:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII="})},d.copy=function(){d.resize(),d.target.attr({href:d.canvas.toDataURL("image/png")})}):(d.targetFo=t.renderer.createElement("foreignObject").add(o),a.renderTarget=d.target=p.createElement("canvas"),d.targetCtx=d.target.getContext("2d"),d.targetFo.element.appendChild(d.target),d.clear=function(){d.target.width=d.canvas.width,d.target.height=d.canvas.height},d.copy=function(){d.target.width=d.canvas.width,d.target.height=d.canvas.height,d.targetCtx.drawImage(d.canvas,0,0)}),d.resize=function(){s=t.chartWidth,r=t.chartHeight,(d.targetFo||d.target).attr({x:0,y:0,width:s,height:r}).css({pointerEvents:"none",mixedBlendMode:"normal",opacity:1}),a instanceof i&&a.boost.markerGroup.translate(t.plotLeft,t.plotTop)},d.clipRect=t.renderer.clipRect(),(d.targetFo||d.target).attr({zIndex:e.options.zIndex}),a instanceof i&&(a.boost.markerGroup=a.renderer.g().add(o).translate(e.xAxis.pos,e.yAxis.pos))),d.canvas.width=s,d.canvas.height=r,d.clipRect){var f=h(t,a),g=f.width===t.clipBox.width&&f.height===t.clipBox.height?o:d.targetFo||d.target;d.clipRect.attr(f),null==g||g.clip(d.clipRect)}return d.resize(),d.clear(),!d.wgl&&(d.wgl=new n(function(t){t.settings.debug.timeBufferCopy&&console.time("buffer copy"),d.copy(),t.settings.debug.timeBufferCopy&&console.timeEnd("buffer copy")}),d.wgl.init(d.canvas)||x("[highcharts boost] - unable to init WebGL renderer"),d.wgl.setOptions(t.options.boost||{}),a instanceof i&&d.wgl.allocateBuffer(t)),d.wgl.setSize(s,r),d.wgl}function k(t){var e=t.points;if(e){var i=void 0,o=void 0;for(o=0;o<e.length;o+=1)(i=e[o])&&i.destroyElements&&i.destroyElements()}["graph","area","tracker"].forEach(function(e){var i=t[e];i&&(t[e]=i.destroy())});for(var s=0,r=t.zones;s<r.length;s++)b(r[s],void 0,!0)}function w(t,e,i,o,s,r){for(var n=(s=s||0)+(o=o||3e3),a=!0;a&&s<n&&s<t.length;)a=e(t[s],s),++s;a&&(s<t.length?r?w(t,e,i,o,s,r):g.requestAnimationFrame?g.requestAnimationFrame(function(){w(t,e,i,o,s)}):setTimeout(w,0,t,e,i,o,s):i&&i())}function D(t,e){var i=t.options,o=i.data,s=t.xAxis&&t.xAxis.options,r=t.yAxis&&t.yAxis.options,n=t.colorAxis&&t.colorAxis.options;return o.length>(i.boostThreshold||Number.MAX_VALUE)&&P(r.min)&&P(r.max)&&(!e||P(s.min)&&P(s.max))&&(!n||P(n.min)&&P(n.max))}var B=function(t,e){return!t.forceCrop&&(c(t.chart)||(e?e.length:0)>=(t.options.boostThreshold||Number.MAX_VALUE))};function L(){var t=this,e=t.chart;e.boost&&e.boost.markerGroup===t.markerGroup&&(t.markerGroup=null),e.hoverPoints&&(e.hoverPoints=e.hoverPoints.filter(function(e){return e.series===t})),e.hoverPoint&&e.hoverPoint.series===t&&(e.hoverPoint=null)}function N(){var t=this.boost;t&&t.canvas&&t.target&&(t.wgl&&t.wgl.clear(),t.clear&&t.clear())}function _(t){var e=t.boost;e&&e.canvas&&e.target&&e.wgl&&!c(t.chart)&&e.wgl.render(t.chart)}function z(t,e){var i=t.options,o=t.xAxis,s=t.pointClass;if(e instanceof s)return e;var r=t.xData||i.xData||t.processedXData||!1,n=new s(t,(t.options.data||[])[e.i],r?r[e.i]:void 0);return n.category=T(o.categories?o.categories[n.x]:n.x,n.x),n.dist=e.dist,n.distX=e.distX,n.plotX=e.plotX,n.plotY=e.plotY,n.index=e.i,n.percentage=e.percentage,n.isInside=t.isPointInside(n),n}function I(t){var e=this.options,i=this.xAxis,o=this.yAxis;if(!this.isDirty&&!i.isDirty&&!o.isDirty&&!t)return!1;this.yAxis.setTickInterval();var s=e.boostThreshold||0,r=e.cropThreshold,n=e.data||this.data,a=this.xData,l=i.getExtremes(),h=null!==(g=l.max)&&void 0!==g?g:Number.MAX_VALUE,c=null!==(m=l.min)&&void 0!==m?m:-Number.MAX_VALUE,u=this.yData,d=o.getExtremes(),p=null!==(b=d.max)&&void 0!==b?b:Number.MAX_VALUE,f=null!==(x=d.min)&&void 0!==x?x:-Number.MAX_VALUE;if(!this.boosted&&i.old&&o.old&&c>=(null!==(v=i.old.min)&&void 0!==v?v:-Number.MAX_VALUE)&&h<=(null!==(A=i.old.max)&&void 0!==A?A:Number.MAX_VALUE)&&f>=(null!==(y=o.old.min)&&void 0!==y?y:-Number.MAX_VALUE)&&p<=(null!==(T=o.old.max)&&void 0!==T?T:Number.MAX_VALUE))return null!==(E=this.processedXData)&&void 0!==E||(this.processedXData=a),null!==(S=this.processedYData)&&void 0!==S||(this.processedYData=u),!0;if(!s||n.length<s||r&&!this.forceCrop&&!this.getExtremesFromAll&&!e.getExtremesFromAll&&n.length<r)return this.processedXData=a,this.processedYData=u,!0;for(var g,m,b,x,v,A,y,T,E,S,C,M,U,R,k,w,D,L,N,_,z=[],I=[],G=[],O=!(P(l.max)||P(l.min)),X=!(P(d.max)||P(d.min)),V=!1,j=a[0],F=a[0],Y=u[0],H=u[0],W=0,K=a.length;W<K;++W)N=a[W],_=u[W],N>=c&&N<=h&&_>=f&&_<=p?(z.push({x:N,y:_}),I.push(N),G.push(_),O&&(j=Math.max(j,N),F=Math.min(F,N)),X&&(Y=Math.max(Y,_),H=Math.min(H,_))):V=!0;return O&&(null!==(C=(k=i.options).max)&&void 0!==C||(k.max=j),null!==(M=(w=i.options).min)&&void 0!==M||(w.min=F)),X&&(null!==(U=(D=o.options).max)&&void 0!==U||(D.max=Y),null!==(R=(L=o.options).min)&&void 0!==R||(L.min=H)),this.cropped=V,this.cropStart=0,this.processedXData=I,this.processedYData=G,B(this,I)||(this.processedData=z),!0}function G(){var t,e,i,o,s,r=this,n=this.options||{},l=this.chart,h=this.xAxis,u=this.yAxis,d=n.xData||this.processedXData,p=n.yData||this.processedYData,g=this.processedData||n.data,m=h.getExtremes(),b=m.min-(h.minPointOffset||0),x=m.max+(h.minPointOffset||0),v=u.getExtremes(),y=v.min-(u.minPointOffset||0),P=v.max+(u.minPointOffset||0),T={},E=!!this.sampling,S=n.enableMouseTracking,U=n.threshold,D=this.pointArrayMap&&"low,high"===this.pointArrayMap.join(","),B=!!n.stacking,L=this.cropStart||0,N=this.requireSorting,z=!d,I="x"===n.findNearestPointBy,G=this.xData||this.options.xData||this.processedXData||!1,O=!1,X=u.getThreshold(U);if(!h.isPanning&&!u.isPanning&&(O=R(l,this),l.boosted=!0,this.visible)){(this.points||this.graph)&&k(this),c(l)?(this.markerGroup&&this.markerGroup!==l.boost.markerGroup&&this.markerGroup.destroy(),this.markerGroup=l.boost.markerGroup,this.boost&&this.boost.target&&(this.renderTarget=this.boost.target=this.boost.target.destroy())):(l.boost&&this.markerGroup===l.boost.markerGroup&&(this.markerGroup=void 0),this.markerGroup=this.plotGroup("markerGroup","markers",!0,1,l.seriesGroup));var V=this.points=[],j=function(t,e,i,o){var s=!!G&&G[L+i],r=function(t){l.inverted&&(t=h.len-t,e=u.len-e),V.push({destroy:f,x:s,clientX:t,plotX:t,plotY:e,i:L+i,percentage:o})};t=Math.ceil(t),a=I?t:t+","+e,S&&(T[a]?s===G[G.length-1]&&(V.length--,r(t)):(T[a]=!0,r(t)))};this.buildKDTree=f,A(this,"renderCanvas"),O&&(M(O,this),O.pushSeries(this),_(this));var F=O.settings;l.renderer.forExport||(F.debug.timeKDTree&&console.time("kd tree building"),w(B?this.data.slice(L):d||g,function(r,n){var a,c,d,f,g,m=void 0===l.index,v=!1,A=!0;return!C(r)||(!m&&(z?(a=r[0],c=r[1]):(a=r,c=p[n]),D?(z&&(c=r.slice(1,3)),v=c[0],c=c[1]):B&&(a=r.x,v=(c=r.stackY)-r.y,g=r.percentage),N||(A=(c||0)>=y&&c<=P),null!==c&&a>=b&&a<=x&&A&&(d=h.toPixels(a,!0),E?((void 0===o||d===t)&&(D||(v=c),(void 0===s||c>i)&&(i=c,s=n),(void 0===o||v<e)&&(e=v,o=n)),I&&d===t||(void 0!==o&&(f=u.toPixels(i,!0),X=u.toPixels(e,!0),j(d,f,s,g),X!==f&&j(d,X,o,g)),o=s=void 0,t=d)):j(d,f=Math.ceil(u.toPixels(c,!0)),n,g))),!m)},function(){A(r,"renderedCanvas"),delete r.buildKDTree,r.options&&r.buildKDTree(),F.debug.timeKDTree&&console.timeEnd("kd tree building")}))}}function O(t){var e=!0;if(this.chart.options&&this.chart.options.boost&&(e=void 0===this.chart.options.boost.enabled||this.chart.options.boost.enabled),!e||!this.boosted)return t.call(this);this.chart.boosted=!0;var i=R(this.chart,this);i&&(M(i,this),i.pushSeries(this)),_(this)}function X(t){if(this.boosted){if(D(this))return{};if(this.xAxis.isPanning||this.yAxis.isPanning)return this}return t.apply(this,[].slice.call(arguments,1))}function V(e){var i,o,s=this.options.data;if(U(this.chart)&&t[this.type]){var r,n,a=this.is("scatter")&&!this.is("bubble");if(!B(this,s)||a||this.options.stacking||!D(this,!0)){if(this.boosted&&((null===(i=this.xAxis)||void 0===i?void 0:i.isPanning)||(null===(o=this.yAxis)||void 0===o?void 0:o.isPanning)))return;a&&!this.yAxis.treeGrid?I.call(this,arguments[1]):e.apply(this,[].slice.call(arguments,1)),s=this.processedXData}if(this.boosted=B(this,s),this.boosted){var l=void 0;this.options.data&&this.options.data.length&&!P(l=this.getFirstValidPoint(this.options.data))&&!y(l)&&x(12,!1,this.chart),function(t){t.boost=t.boost||{getPoint:function(e){return z(t,e)}};var e,i=t.boost.altered=[];if(["allowDG","directTouch","stickyTracking"].forEach(function(e){i.push({prop:e,val:t[e],own:Object.hasOwnProperty.call(t,e)})}),t.allowDG=!1,t.directTouch=!1,t.stickyTracking=!0,t.finishedAnimating=!0,t.labelBySeries&&(t.labelBySeries=t.labelBySeries.destroy()),t.is("scatter")&&t.data.length){for(var o=0,s=t.data;o<s.length;o++){var r=s[o];null===(e=null==r?void 0:r.destroy)||void 0===e||e.call(r)}t.data.length=0,t.points.length=0,delete t.processedData}}(this)}else r=this,(n=r.boost)&&((n.altered||[]).forEach(function(t){t.own?r[t.prop]=t.val:delete r[t.prop]}),n.clear&&n.clear())}else e.apply(this,[].slice.call(arguments,1))}function j(t){var e=t.apply(this,[].slice.call(arguments,1));return this.boost&&e?this.boost.getPoint(e):e}return{compose:function(i,o,s){if(E(d,"Boost.Series")){var r=u().plotOptions,n=i.prototype;if(m(i,"destroy",L),m(i,"hide",N),s&&(n.renderCanvas=G),S(n,"getExtremes",X),S(n,"processData",V),S(n,"searchPoint",j),["translate","generatePoints","drawTracker","drawPoints","render"].forEach(function(e){return function(e,i,o){function s(e){var i=this.options.stacking&&("translate"===o||"generatePoints"===o);this.boosted&&!i&&U(this.chart)&&"heatmap"!==this.type&&"treemap"!==this.type&&t[this.type]&&0!==this.options.boostThreshold?"render"===o&&this.renderCanvas&&this.renderCanvas():e.call(this)}if(S(e,o,s),"translate"===o)for(var r=0,n=["column","arearange","columnrange","heatmap","treemap"];r<n.length;r++){var a=n[r];i[a]&&S(i[a].prototype,o,s)}}(n,o,e)}),e.forEach(function(t){var e=r[t];e&&(e.boostThreshold=5e3,e.boostData=[],o[t].prototype.fillOpacity=!0)}),s){var a=o.area,l=o.areaspline,h=o.bubble,c=o.column,p=o.heatmap,f=o.scatter,g=o.treemap;if(a&&v(a.prototype,{fill:!0,fillOpacity:!0,sampling:!0}),l&&v(l.prototype,{fill:!0,fillOpacity:!0,sampling:!0}),h){var b=h.prototype;delete b.buildKDTree,S(b,"markerAttribs",function(t){return!this.boosted&&t.apply(this,[].slice.call(arguments,1))})}c&&v(c.prototype,{fill:!0,sampling:!0}),f&&(f.prototype.fill=!0),[p,g].forEach(function(t){t&&S(t.prototype,"drawPoints",O)})}}return i},destroyGraphics:k,eachAsync:w,getPoint:z}}),i(e,"Extensions/BoostCanvas.js",[e["Extensions/Boost/BoostChart.js"],e["Extensions/Boost/BoostSeries.js"],e["Core/Color/Color.js"],e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e,i,o,s){var r,n=t.getBoostClipRect,a=t.isChartSeriesBoosting,l=e.destroyGraphics,h=i.parse,c=o.doc,u=o.noop,d=s.addEvent,p=s.fireEvent,f=s.isNumber,g=s.merge,m=s.pick,b=s.wrap;return function(t){var o,r="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII=";function x(t,e,i,o,s){s&&e!==s.clientX&&(t.moveTo(s.clientX,s.yBottom),t.lineTo(s.clientX,s.plotY),t.lineTo(e,i),t.lineTo(e,o))}function v(t,e,i,o,s){t.moveTo(e,i),t.arc(e,i,this.radii&&this.radii[s],0,2*Math.PI,!1)}function A(t,e,i,o){t.rect(e-1,i,1,o-i)}function y(){this.boost&&this.boost.copy&&this.boost.copy()}function P(){var t=this.boost||{};t.target&&t.target.attr({href:r}),t.canvas&&t.canvas.getContext("2d").clearRect(0,0,t.canvas.width,t.canvas.height)}function T(){a(this.chart)?this.boost&&this.boost.clear&&this.boost.clear():this.boost&&this.boost.copy?this.boost.copy():this.chart.boost&&this.chart.boost.copy&&this.chart.boost.copy()}function E(t,e,i){t.lineTo(e,i)}function S(){var t,e=this.chart,i=a(e)?e:this,o=i===e?e.seriesGroup:e.seriesGroup||this.group,s=e.chartWidth,l=e.chartHeight,h=function(t,e,i,o,s,r,n){t.call(this,i,e,o,s,r,n)},u=i.boost=i.boost||{};return t=u.targetCtx,u.canvas||(u.canvas=c.createElement("canvas"),u.target=e.renderer.image("",0,0,s,l).addClass("highcharts-boost-canvas").add(o),t=u.targetCtx=u.canvas.getContext("2d"),e.inverted&&["moveTo","lineTo","rect","arc"].forEach(function(e){b(t,e,h)}),u.copy=function(){u.target.attr({href:u.canvas.toDataURL("image/png")})},u.clear=function(){t.clearRect(0,0,u.canvas.width,u.canvas.height),i===u.target&&u.target.attr({href:r})},u.clipRect=e.renderer.clipRect(),u.target.clip(u.clipRect)),u.canvas.width!==s&&(u.canvas.width=s),u.canvas.height!==l&&(u.canvas.height=l),u.target.attr({x:0,y:0,width:s,height:l,style:"pointer-events: none",href:r}),u.clipRect&&u.clipRect.attr(n(e,i)),t}function C(){var t=this,n=t.options,a=t.chart,c=t.xAxis,b=t.yAxis,x=a.options.boost||{},v={timeRendering:x.timeRendering||!1,timeSeriesProcessing:x.timeSeriesProcessing||!1,timeSetup:x.timeSetup||!1},A=t.processedXData,y=t.processedYData,P=n.data,T=c.getExtremes(),E=T.min,S=T.max,C=b.getExtremes(),M=C.min,U=C.max,R={},k=!!t.sampling,w=n.marker&&n.marker.radius,D=t.cvsStrokeBatch||1e3,B=n.enableMouseTracking,L=n.threshold,N=f(L),_=b.getThreshold(L),z=t.fill,I=t.pointArrayMap&&"low,high"===t.pointArrayMap.join(","),G=!!n.stacking,O=t.cropStart||0,X=a.options.loading,V=t.requireSorting,j=n.connectNulls,F=!A,Y=G?t.data:A||P,H=t.fillOpacity?i.parse(t.color).setOpacity(m(n.fillOpacity,.75)).get():t.color,W="x"===n.findNearestPointBy,K=this.boost||{},Z=t.cvsDrawPoint,q=n.lineWidth?t.cvsLineTo:void 0,Q=w&&w<=1?t.cvsMarkerSquare:t.cvsMarkerCircle;K.target&&K.target.attr({href:r}),(t.points||t.graph)&&l(t),t.plotGroup("group","series",t.visible?"visible":"hidden",n.zIndex,a.seriesGroup),t.markerGroup=t.group,d(t,"destroy",function(){t.markerGroup=null});var J=this.points=[],$=this.getContext();if(t.buildKDTree=u,K.clear&&K.clear(),t.visible){P.length>99999&&(a.options.loading=g(X,{labelStyle:{backgroundColor:h("#ffffff").setOpacity(.75).get(),padding:"1em",borderRadius:"0.5em"},style:{backgroundColor:"none",opacity:1}}),s.clearTimeout(o),a.showLoading("Drawing..."),a.options.loading=X),v.timeRendering&&console.time("canvas rendering");var tt,te,ti,to,ts,tr,tn,ta,tl=0,th=_,tc=function(){z?($.fillStyle=H,$.fill()):($.strokeStyle=t.color,$.lineWidth=n.lineWidth,$.stroke())},tu=function(e,i,o,s){0===tl&&($.beginPath(),q&&($.lineJoin="round")),a.scroller&&"highcharts-navigator-series"===t.options.className?(i+=a.scroller.top,o&&(o+=a.scroller.top)):i+=a.plotTop,e+=a.plotLeft,ti?$.moveTo(e,i):Z?Z($,e,i,o,te):q?q($,e,i):Q&&Q.call(t,$,e,i,w,s),(tl+=1)===D&&(tc(),tl=0),te={clientX:e,plotY:i,yBottom:o}},td=this.xData||this.options.xData||this.processedXData||!1,tp=function(t,e,i){ta=W?t:t+","+e,B&&!R[ta]&&(R[ta]=!0,a.inverted&&(t=c.len-t,e=b.len-e),J.push({x:!!td&&td[O+i],clientX:t,plotX:t,plotY:e,i:O+i}))};e.eachAsync(Y,function(e,i){var o,s,r,n,l,h,u=void 0===a.index,d=!1,p=!1,f=NaN,g=NaN,m=!0;return!u&&(F?(o=e[0],s=e[1],Y[i+1]&&(f=Y[i+1][0]),Y[i-1]&&(g=Y[i-1][0])):(o=e,s=y[i],Y[i+1]&&(f=Y[i+1]),Y[i-1]&&(g=Y[i-1])),f&&f>=E&&f<=S&&(d=!0),g&&g>=E&&g<=S&&(p=!0),I?(F&&(s=e.slice(1,3)),h=s[0],s=s[1]):G&&(o=e.x,h=(s=e.stackY)-e.y),l=null===s,V||(m=s>=M&&s<=U),!l&&(o>=E&&o<=S&&m||d||p)&&(r=Math.round(c.toPixels(o,!0)),k?((void 0===tr||r===tt)&&(I||(h=s),(void 0===tn||s>ts)&&(ts=s,tn=i),(void 0===tr||h<to)&&(to=h,tr=i)),r!==tt&&(void 0!==tr&&(n=b.toPixels(ts,!0),th=b.toPixels(to,!0),tu(r,N?Math.min(n,_):n,N?Math.max(th,_):th,i),tp(r,n,tn),th!==n&&tp(r,th,tr)),tr=tn=void 0,tt=r)):(tu(r,n=Math.round(b.toPixels(s,!0)),th,i),tp(r,n,i))),ti=l&&!j,i%5e4==0&&(t.boost&&t.boost.copy?t.boost.copy():t.chart.boost&&t.chart.boost.copy&&t.chart.boost.copy())),!u},function(){var e=a.loadingDiv,i=a.loadingShown;tc(),t.canvasToSVG(),v.timeRendering&&console.timeEnd("canvas rendering"),p(t,"renderedCanvas"),i&&(e.style.transition="opacity 250ms",e.opacity=0,a.loadingShown=!1,o=setTimeout(function(){e.parentNode&&e.parentNode.removeChild(e),a.loadingDiv=a.loadingSpan=null},250)),delete t.buildKDTree,t.buildKDTree()},a.renderer.forExport?Number.MAX_VALUE:void 0)}}function M(t,e,i,o){t.moveTo(e,i),t.arc(e,i,o,0,2*Math.PI,!1)}function U(t,e,i,o){t.rect(e-o,i-o,2*o,2*o)}function R(){var t=this.chart,e=this.getContext(),i=this.chart.inverted,o=this.xAxis,s=this.yAxis;e?(this.points.forEach(function(r){var n,a=r.plotY;if(void 0!==a&&!isNaN(a)&&null!==r.y&&e){var l=r.shapeArgs||{},h=l.x,c=void 0===h?0:h,u=l.y,d=void 0===u?0:u,p=l.width,f=void 0===p?0:p,g=l.height,m=void 0===g?0:g;n=t.styledMode?r.series.colorAttribs(r):r.series.pointAttribs(r),e.fillStyle=n.fill,i?e.fillRect(s.len-d+o.left,o.len-c+s.top,-m,-f):e.fillRect(c+o.left,d+s.top,f,m)}}),this.canvasToSVG()):this.chart.showLoading("Your browser doesn't support HTML5 canvas, <br>please use a modern browser")}t.compose=function(t,e,i){var o=e.prototype;if(!o.renderCanvas){var s=i.area,r=i.bubble,n=i.column,a=i.heatmap,l=i.scatter;if(t.prototype.callbacks.push(function(t){d(t,"predraw",P),d(t,"render",y)}),o.canvasToSVG=T,o.cvsLineTo=E,o.getContext=S,o.renderCanvas=C,s){var h=s.prototype;h.cvsDrawPoint=x,h.fill=!0,h.fillOpacity=!0,h.sampling=!0}if(r){var c=r.prototype;c.cvsMarkerCircle=v,c.cvsStrokeBatch=1}if(n){var u=n.prototype;u.cvsDrawPoint=A,u.fill=!0,u.sampling=!0}if(a&&b(a.prototype,"drawPoints",R),l){var p=l.prototype;p.cvsMarkerCircle=M,p.cvsMarkerSquare=U,p.fill=!0}}}}(r||(r={})),r}),i(e,"masters/modules/boost-canvas.src.js",[e["Core/Globals.js"],e["Extensions/BoostCanvas.js"]],function(t,e){return t.initCanvasBoost=function(){e.compose(t.Chart,t.Series,t.seriesTypes)},t})});