<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <div class="card card-info card-outline">
            <div class="card-header">
                <h3 class="card-title text-bold"><?= $title ?></h3>

                <span class="float-right">
                    <?= anchor($locale . "/ps/formations", "<i class='fa fa-tasks'></i> " . lang("Params.btn_list"), ['class' => 'btn btn-primary btn-sm']) ?>
                </span>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php

                    use App\Traits\CommonTrait;
                    use CodeIgniter\View\Table;
                    use Modules\Params\Models\BrancheModel;
                    use Modules\Params\Models\CommuneModel;

                    if (!empty(session()->getFlashdata('message'))) {
                        echo session()->getFlashdata('message');
                    }
                    // print_r(validation_list_errors());

                    ?>
                </div>

                <?php echo form_open($locale . $route, NULL, ['id' => (string)$formation->id]); ?>
                <div class="row mb-3">
                    <div class="col-md-3">
                        <?= form_label("Intitule de la formation"); ?>

                        <?php
                        $intituleFormation = [
                            'type'  => 'text',
                            'name'  => 'intituleFormation',
                            'id'    => 'intituleFormation',
                            'value' => set_value('intituleFormation', $formation->intituleFormation),
                            'placeholder' => "Intitule",
                            'class' => 'form-control',
                        ];

                        echo form_input($intituleFormation);
                        ?>
                        <?= !empty(validation_show_error('intituleFormation')) ? "<p class='text-danger'>" . validation_show_error('intituleFormation') . "</p>" : "" ?>
                    </div>

                    <?php

                    $br = [
                        'type'  => 'hidden',
                        'name'  => 'branche_id_load',
                        'id'    => 'branche_id_load',
                        'value' => $formation->brancheId,
                    ];

                    echo form_input($br);

                    $cm = [
                        'type'  => 'hidden',
                        'name'  => 'commune_id_load',
                        'id'    => 'commune_id_load',
                        'value' => $formation->communeId,
                    ];

                    echo form_input($cm);
                    ?>

                    <div class="col-md-3">
                        <?= form_label("Branche"); ?>
                        <?php
                        echo form_dropdown('brancheId', $branches, set_value('brancheId', $formation->brancheId), "class = 'form-control' id='brancheId'");
                        ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Commune"); ?>
                        <?php
                        echo form_dropdown('communeId', [], set_value('communeId', $formation->communeId), "class = 'form-control' id='communeId'");
                        ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Formateur1 ( Nom et prénom)"); ?>

                        <?php
                        $formateurUnNomPrenom = [
                            'type'  => 'text',
                            'name'  => 'formateurUnNomPrenom',
                            'id'    => 'formateurUnNomPrenom',
                            'value' => set_value('formateurUnNomPrenom', $formation->formateurUnNomPrenom),
                            'placeholder' => "Formateur1 ( Nom et prénom)",
                            'class' => 'form-control',
                        ];

                        echo form_input($formateurUnNomPrenom);
                        ?>
                        <?= !empty(validation_show_error('formateurUnNomPrenom')) ? "<p class='text-danger'>" . validation_show_error('formateurUnNomPrenom') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Formateur2 ( Nom et prénom)"); ?>

                        <?php
                        $formateurDeuxNomPrenom = [
                            'type'  => 'text',
                            'name'  => 'formateurDeuxNomPrenom',
                            'id'    => 'formateurDeuxNomPrenom',
                            'value' => set_value('formateurDeuxNomPrenom', $formation->formateurDeuxNomPrenom),
                            'placeholder' => "Formateur2 ( Nom et prénom)",
                            'class' => 'form-control',
                        ];

                        echo form_input($formateurDeuxNomPrenom);
                        ?>
                        <?= !empty(validation_show_error('formateurDeuxNomPrenom')) ? "<p class='text-danger'>" . validation_show_error('formateurDeuxNomPrenom') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Date de formation <font color='red'>*</font>"); ?>
                        <?php $date = $formation->dateFormation ? $formation->dateFormation : set_value('dateFormation') ?>
                        <div class="input-group date" id="dateFormation" data-target-input="nearest">
                            <?= form_input('dateFormation', $date, "class='form-control datetimepicker-input', id='dateFormation' placeholder='Date de formation'") ?>
                            <div class="input-group-append" data-target="#dateFormation" data-toggle="datetimepicker">
                                <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                            </div>
                        </div>
                        <?= !empty(validation_show_error('dateFormation')) ? "<p class='text-danger'>" . validation_show_error('dateFormation') . "</p>" : "" ?>

                    </div>

                    <div class="col-md-3">
                        <?= form_label("Catégorie de formation"); ?>
                        <?php
                        echo form_dropdown('categorieId', $categories, set_value('categorieId', $formation->categorieId), "class = 'form-control' id='categorieId'");
                        ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Niveau de formation"); ?>
                        <?php
                        echo form_dropdown('niveauId', $niveaux, set_value('niveauId', $formation->niveauId), "class = 'form-control' id='niveauId'");
                        ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Type de formation"); ?>
                        <?php
                        echo form_dropdown('typeFormationId', $types, set_value('typeFormationId', $formation->typeFormationId), "class = 'form-control' id='typeFormationId'");
                        ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Date d'expiration du certificat (2ans  après formation)"); ?>
                        <?php $date = $formation->dateExpiration ? $formation->dateExpiration : set_value('dateExpiration') ?>
                        <div class="input-group date" id="dateExpiration" data-target-input="nearest">
                            <?= form_input('dateExpiration', $date, "class='form-control datetimepicker-input', id='dateExpiration' placeholder='Date de naissance'") ?>
                            <div class="input-group-append" data-target="#dateExpiration" data-toggle="datetimepicker">
                                <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                            </div>
                        </div>
                        <?= !empty(validation_show_error('dateExpiration')) ? "<p class='text-danger'>" . validation_show_error('dateExpiration') . "</p>" : "" ?>

                    </div>

                    <div class="col-md-1 mt-5">
                        <?php
                        echo form_submit("mysubmit", lang("Params.btn_save"), "class='btn btn-primary btn-sm mt-1'");
                        ?>
                    </div>
                </div>
                <?php echo form_close(); ?>


                <?php if ($formation->id > 0) { ?>
                    <legend>Ajouter des membres</legend>
                    <?php
                    echo form_open($locale . "/ps/formations/ajouterMembre", NULL, ['formationId' => (string)$formation->id]); ?>
                    <div class="row mb-3">
                        <div class="col-md-3">
                            <?= form_label("Nom du participant"); ?>

                            <?php
                            $nomParticipant = [
                                'type'  => 'text',
                                'name'  => 'nomParticipant',
                                'id'    => 'nomParticipant',
                                'value' => set_value('nomParticipant', $membre->nomParticipant),
                                'placeholder' => "Nom du participant",
                                'class' => 'form-control',
                            ];

                            echo form_input($nomParticipant);
                            ?>
                            <?= !empty(validation_show_error('nomParticipant')) ? "<p class='text-danger'>" . validation_show_error('nomParticipant') . "</p>" : "" ?>
                        </div>


                        <div class="col-md-3">
                            <?= form_label("Prénom du Participant"); ?>

                            <?php
                            $prenomParticipant = [
                                'type'  => 'text',
                                'name'  => 'prenomParticipant',
                                'id'    => 'prenomParticipant',
                                'value' => set_value('prenomParticipant', $membre->prenomParticipant),
                                'placeholder' => "Prénom du Participant",
                                'class' => 'form-control',
                            ];

                            echo form_input($prenomParticipant);
                            ?>
                            <?= !empty(validation_show_error('prenomParticipant')) ? "<p class='text-danger'>" . validation_show_error('prenomParticipant') . "</p>" : "" ?>
                        </div>

                        <div class="col-md-3">
                            <?= form_label("CNI du participant"); ?>

                            <?php
                            $cniParticipant = [
                                'type'  => 'text',
                                'name'  => 'cniParticipant',
                                'id'    => 'cniParticipant',
                                'value' => set_value('cniParticipant', $membre->cniParticipant),
                                'placeholder' => "CNI du participant",
                                'class' => 'form-control',
                            ];

                            echo form_input($cniParticipant);
                            ?>
                            <?= !empty(validation_show_error('cniParticipant')) ? "<p class='text-danger'>" . validation_show_error('cniParticipant') . "</p>" : "" ?>
                        </div>

                        <div class="col-md-3">
                            <?= form_label("Date de naissance <font color='red'>*</font>"); ?>
                            <?php $date = $membre->dateNaissance ? $membre->dateNaissance : set_value('dateNaissance') ?>
                            <div class="input-group date" id="dateNaissance" data-target-input="nearest">
                                <?= form_input('dateNaissance', $date, "class='form-control datetimepicker-input', id='dateNaissance' placeholder='Date de naissance'") ?>
                                <div class="input-group-append" data-target="#dateNaissance" data-toggle="datetimepicker">
                                    <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                </div>
                            </div>
                            <?= !empty(validation_show_error('dateNaissance')) ? "<p class='text-danger'>" . validation_show_error('dateNaissance') . "</p>" : "" ?>

                        </div>

                        <div class="col-md-3">
                            <?= form_label("Sexe (M, F)"); ?>
                            <?php
                            echo form_dropdown('sexe', $sexes, set_value('sexe', $membre->sexe), "class = 'form-control' id='sexe'");
                            ?>
                        </div>

                        <div class="col-md-3">
                            <?= form_label("Téléphone portable"); ?>

                            <?php
                            $telephone = [
                                'type'  => 'text',
                                'name'  => 'telephone',
                                'id'    => 'telephone',
                                'value' => set_value('telephone', $membre->telephone),
                                'placeholder' => "Téléphone portable",
                                'class' => 'form-control',
                            ];

                            echo form_input($telephone);
                            ?>
                            <?= !empty(validation_show_error('telephone')) ? "<p class='text-danger'>" . validation_show_error('telephone') . "</p>" : "" ?>
                        </div>

                        <?php

                        $brResid = [
                            'type'  => 'hidden',
                            'name'  => 'branche_residence_id_load',
                            'id'    => 'branche_residence_id_load',
                            'value' => $membre->brancheResidenceId,
                        ];

                        echo form_input($brResid);

                        $cmResid = [
                            'type'  => 'hidden',
                            'name'  => 'commune_residence_id_load',
                            'id'    => 'commune_residence_id_load',
                            'value' => $membre->communeResidenceId,
                        ];

                        echo form_input($cmResid);
                        ?>

                        <div class="col-md-3">
                            <?= form_label("Branche résidence"); ?>
                            <?php
                            echo form_dropdown('brancheResidenceId', $branches, set_value('brancheResidenceId', $membre->brancheResidenceId), "class = 'form-control' id='brancheResidenceId'");
                            ?>
                        </div>

                        <div class="col-md-3">
                            <?= form_label("Commune résidence"); ?>
                            <?php
                            echo form_dropdown('communeResidenceId', [], set_value('communeResidenceId', $membre->communeResidenceId), "class = 'form-control' id='communeResidenceId'");
                            ?>
                        </div>

                        <div class="col-md-3">
                            <?= form_label("Reçu certificat de formation"); ?>
                            <?php
                            echo form_dropdown('certificat', $certificats, set_value('certificat', $membre->certificat), "class = 'form-control' id='certificat'");
                            ?>
                        </div>
                        <div class="col-md-1 mt-4">
                            <?php
                            echo form_submit("mysubmit", lang("Params.btn_save"), "class='btn btn-primary btn-sm mt-1'");
                            ?>
                        </div>
                    </div>
                    <?php
                    echo form_close();
                    ?>
                    <?php

                    if (!empty($membres)) {


                        $table = new Table();

                        $template = [
                            'table_open' => '<table class="table table-bordered" id="myList">',
                        ];

                        $table->setTemplate($template);
                        $table->setHeading("#", "PARTICIPANT", "TELEPHONE", "CNI", "BRANCHE", "COMMUNE", "CERTIFICAT", "OPTIONS");
                        $i = 1;
                        foreach ($membres as $membre) {
                            $sub_array = [];
                            $sub_array[] = $i;
                            $sub_array[] = $membre->nomParticipant . " " . $membre->prenomParticipant;
                            $sub_array[] = $membre->telephone;
                            $sub_array[] = $membre->cniParticipant;
                            $sub_array[] =  CommonTrait::formatData(new BrancheModel(), $membre->brancheResidenceId);
                            $sub_array[] = CommonTrait::formatData(new CommuneModel(), $membre->communeResidenceId);
                            $sub_array[] = $membre->certificat;
                            $sub_array[] = anchor($locale . "/ps/formations/supprimerMembre/" . $membre->id . '/' . $membre->formationId, "<i class='fa fa-trash'></i>", ['class' => 'text-danger'])
                                . " " . anchor($locale . "/ps/formations/certificat/" . $membre->id, "<i class='fa fa-file-pdf'></i>", ['class' => 'text-info', 'target' => '_blank']);

                            $table->addRow($sub_array);
                            $i++;
                        }
                        echo $table->generate();
                    }
                    ?>
                <?php } ?>


            </div>
        </div>
    </section>
</div>


<?= $this->endSection(); ?>