<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <div class="card card-info card-outline">
            <div class="card-header">
                <h3 class="card-title text-bold"><?= $title ?></h3>

                <span class="float-right">
                    <?= anchor($locale . "/data/infrastructure", "<i class='fa fa-tasks'></i> " . lang("Params.btn_list"), ['class' => 'btn btn-primary btn-sm']) ?>
                </span>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php
                    if (!empty(session()->getFlashdata('message'))) {
                        echo session()->getFlashdata('message');
                    }
                    
                    ?>
                </div>

                <?php echo form_open($locale . $route, NULL, ['id' => (string)$infrastructure->id]); ?>
                <div class="row mb-3">
                    
                    <?php

                    $br = [
                        'type'  => 'hidden',
                        'name'  => 'branche_id_load',
                        'id'    => 'branche_id_load',
                        'value' => $infrastructure->brancheId,
                    ];

                    echo form_input($br);

                    $cm = [
                        'type'  => 'hidden',
                        'name'  => 'commune_id_load',
                        'id'    => 'commune_id_load',
                        'value' => $infrastructure->communeId,
                    ];

                    echo form_input($cm);

                    $zn = [
                        'type'  => 'hidden',
                        'name'  => 'zone_id_load',
                        'id'    => 'zone_id_load',
                        'value' => $infrastructure->zoneId,
                    ];

                    echo form_input($zn);

                    $cl = [
                        'type'  => 'hidden',
                        'name'  => 'colline_id_load',
                        'id'    => 'colline_id_load',
                        'value' => $infrastructure->collineId,
                    ];

                    echo form_input($cl);
                    ?>

                    <div class="col-md-4">
                        <?= form_label("Branche <font color='red'>*</font>"); ?>
                        <?php
                        echo form_dropdown('brancheId', $branches, set_value('brancheId', $infrastructure->brancheId), "class = 'form-control' id='brancheId'");
                        ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Commune <font color='red'>*</font>"); ?>
                        <?php
                        echo form_dropdown('communeId', [], set_value('communeId', $infrastructure->communeId), "class = 'form-control' id='communeId'");
                        ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Zone <font color='red'>*</font>"); ?>
                        <?php
                        echo form_dropdown('zoneId', [], set_value('zoneId', $infrastructure->zoneId), "class = 'form-control' id='zoneId'");
                        ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Colline <font color='red'>*</font>"); ?>
                        <?php
                        echo form_dropdown('collineId', [], set_value('collineId', $infrastructure->collineId), "class = 'form-control' id='collineId'");
                        ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Type d'infrastructure <font color='red'>*</font>"); ?>
                        <?php
                        echo form_dropdown('typeInfrastructureId', $typeInfrastructures, set_value('typeInfrastructureId', $infrastructure->typeInfrastructureId), "class = 'form-control' ");
                        ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Titre immobilier acquis <font color='red'>*</font>"); ?>
                        <?php
                        echo form_dropdown('acquisitionProprieteImmo', $yesnon, set_value('acquisitionProprieteImmo', $infrastructure->acquisitionProprieteImmo), "class = 'form-control' ");
                        ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Type d’attestation <font color='red'>*</font>"); ?>
                        <?php
                        echo form_dropdown('typeAttestationId', $typeAttestations, set_value('typeAttestationId', $infrastructure->typeAttestationId), "class = 'form-control' ");
                        ?>
                    </div>                    

                    <div class="col-md-4">
                    <?= form_label("Coût estimé"); ?>

                        <?php
                        $coutEstime = [
                            'type'  => 'text',
                            'name'  => 'coutEstime',
                            'id'    => 'coutEstime',
                            'value' => set_value('coutEstime', $infrastructure->coutEstime),
                            'placeholder' => "Coût estimé",
                            'class' => 'form-control',
                        ];

                        echo form_input($coutEstime);
                        ?>
                        <?= !empty(validation_show_error('coutEstime')) ? "<p class='text-danger'>" . validation_show_error('coutEstime') . "</p>" : "" ?>
                    </div>
                    
                    <div class="col-md-1 mt-4">
                        <?php
                        echo form_submit("mysubmit", lang("Params.btn_save"), "class='btn btn-primary btn-sm mt-1'");
                        ?>
                    </div>
                </div>
                <?php echo form_close(); ?>


            </div>
        </div>
    </section>
</div>


<?= $this->endSection(); ?>