<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <div class="card card-info card-outline">
            <div class="card-header">
                <h3 class="card-title text-bold"><?= $title ?></h3>

                <span class="float-right">
                    <?= anchor($locale . "/data/ambulance", "<i class='fa fa-tasks'></i> " . lang("Params.btn_list"), ['class' => 'btn btn-primary btn-sm']) ?>
                </span>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php

                    use App\Traits\CommonTrait;
                    use CodeIgniter\View\Table;
                    use Modules\Params\Models\TypeStaff;

                    if (!empty(session()->getFlashdata('message'))) {
                        echo session()->getFlashdata('message');
                    }

                    ?>
                </div>

                <?php echo form_open($locale . $route, NULL, ['id' => (string)$ambulance->id]); ?>
                <div class="row mb-3">

                    <?php

                    $br = [
                        'type'  => 'hidden',
                        'name'  => 'branche_id_load',
                        'id'    => 'branche_id_load',
                        'value' => $ambulance->brancheId,
                    ];

                    echo form_input($br);

                    $cm = [
                        'type'  => 'hidden',
                        'name'  => 'commune_id_load',
                        'id'    => 'commune_id_load',
                        'value' => $ambulance->communeId,
                    ];

                    echo form_input($cm);

                    $zn = [
                        'type'  => 'hidden',
                        'name'  => 'zone_id_load',
                        'id'    => 'zone_id_load',
                        'value' => $ambulance->zoneId,
                    ];

                    echo form_input($zn);

                    $cl = [
                        'type'  => 'hidden',
                        'name'  => 'colline_id_load',
                        'id'    => 'colline_id_load',
                        'value' => $ambulance->collineId,
                    ];

                    echo form_input($cl);
                    ?>

                    <div class="col-md-3">
                        <?= form_label("Branche <font color='red'>*</font>"); ?>
                        <?php
                        echo form_dropdown('brancheId', $branches, set_value('brancheId', $ambulance->brancheId), "class = 'form-control' id='brancheId'");
                        ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Commune <font color='red'>*</font>"); ?>
                        <?php
                        echo form_dropdown('communeId', [], set_value('communeId', $ambulance->communeId), "class = 'form-control' id='communeId'");
                        ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Zone "); ?>
                        <?php
                        echo form_dropdown('zoneId', [], set_value('zoneId', $ambulance->zoneId), "class = 'form-control' id='zoneId'");
                        ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Colline"); ?>
                        <?php
                        echo form_dropdown('collineId', [], set_value('collineId', $ambulance->collineId), "class = 'form-control' id='collineId'");
                        ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Numéro d'immatriculation <font color='red'>*</font>"); ?>

                        <?php
                        $numImmatriculation = [
                            'type'  => 'text',
                            'name'  => 'numImmatriculation',
                            'id'    => 'numImmatriculation',
                            'value' => set_value('numImmatriculation', $ambulance->numImmatriculation),
                            'placeholder' => "Numéro d'immatriculation",
                            'class' => 'form-control',
                        ];

                        echo form_input($numImmatriculation);
                        ?>
                        <?= !empty(validation_show_error('numImmatriculation')) ? "<p class='text-danger'>" . validation_show_error('numImmatriculation') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Chauffeur <font color='red'>*</font>"); ?>

                        <?php
                        $chauffeur = [
                            'type'  => 'text',
                            'name'  => 'chauffeur',
                            'id'    => 'chauffeur',
                            'value' => set_value('chauffeur', $ambulance->chauffeur),
                            'placeholder' => "Chauffeur",
                            'class' => 'form-control',
                        ];

                        echo form_input($chauffeur);
                        ?>
                        <?= !empty(validation_show_error('chauffeur')) ? "<p class='text-danger'>" . validation_show_error('chauffeur') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Garde malade <font color='red'>*</font>"); ?>

                        <?php
                        $gardeMalade = [
                            'type'  => 'text',
                            'name'  => 'gardeMalade',
                            'id'    => 'gardeMalade',
                            'value' => set_value('gardeMalade', $ambulance->gardeMalade),
                            'placeholder' => "Garde malade",
                            'class' => 'form-control',
                        ];

                        echo form_input($gardeMalade);
                        ?>
                        <?= !empty(validation_show_error('gardeMalade')) ? "<p class='text-danger'>" . validation_show_error('gardeMalade') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Télephone <font color='red'>*</font>"); ?>

                        <?php
                        $telephone = [
                            'type'  => 'text',
                            'name'  => 'telephone',
                            'id'    => 'telephone',
                            'value' => set_value('telephone', $ambulance->telephone),
                            'placeholder' => "Télephone",
                            'class' => 'form-control',
                        ];

                        echo form_input($telephone);
                        ?>
                        <?= !empty(validation_show_error('telephone')) ? "<p class='text-danger'>" . validation_show_error('telephone') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Date de départ <font color='red'>*</font>"); ?>
                        <?php $date = $ambulance->dateDepart ? $ambulance->dateDepart : set_value('dateDepart') ?>
                        <div class="input-group date" id="dateDepart" data-target-input="nearest">
                            <?= form_input('dateDepart', $date, "class='form-control datetimepicker-input', id='dateDepart' placeholder='Date départ'") ?>
                            <div class="input-group-append" data-target="#dateDepart" data-toggle="datetimepicker">
                                <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                            </div>
                        </div>
                        <?= !empty(validation_show_error('dateDepart')) ? "<p class='text-danger'>" . validation_show_error('dateDepart') . "</p>" : "" ?>

                    </div>

                    <div class="col-md-3">
                        <?= form_label("Lieu d’évacuation <font color='red'>*</font>"); ?>

                        <?php
                        $lieuEvacuation = [
                            'type'  => 'text',
                            'name'  => 'lieuEvacuation',
                            'id'    => 'lieuEvacuation',
                            'value' => set_value('lieuEvacuation', $ambulance->lieuEvacuation),
                            'placeholder' => "Lieu d’évacuation",
                            'class' => 'form-control',
                        ];

                        echo form_input($lieuEvacuation);
                        ?>
                        <?= !empty(validation_show_error('lieuEvacuation')) ? "<p class='text-danger'>" . validation_show_error('lieuEvacuation') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Type d’évacuation <font color='red'>*</font>"); ?>
                        <?php
                        echo form_dropdown('typeEvacuationId', $typeEvacuations, set_value('typeEvacuationId', $ambulance->typeEvacuationId), "class = 'form-control' ");
                        ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Destination du patient <font color='red'>*</font>"); ?>

                        <?php
                        $destinationPatient = [
                            'type'  => 'text',
                            'name'  => 'destinationPatient',
                            'id'    => 'destinationPatient',
                            'value' => set_value('destinationPatient', $ambulance->destinationPatient),
                            'placeholder' => "Destination du patient",
                            'class' => 'form-control',
                        ];

                        echo form_input($destinationPatient);
                        ?>
                        <?= !empty(validation_show_error('destinationPatient')) ? "<p class='text-danger'>" . validation_show_error('destinationPatient') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Nom et prénom du patient  <font color='red'>*</font>"); ?>

                        <?php
                        $patient = [
                            'type'  => 'text',
                            'name'  => 'patient',
                            'id'    => 'patient',
                            'value' => set_value('patient', $ambulance->patient),
                            'placeholder' => "Nom et prénom du patient ",
                            'class' => 'form-control',
                        ];

                        echo form_input($patient);
                        ?>
                        <?= !empty(validation_show_error('patient')) ? "<p class='text-danger'>" . validation_show_error('patient') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Sexe <font color='red'>*</font>"); ?>
                        <?php
                        echo form_dropdown('sexe', $genres, set_value('sexe', $ambulance->sexe), "class = 'form-control' ");
                        ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Age du patient <font color='red'>*</font>"); ?>

                        <?php
                        $agePatient = [
                            'type'  => 'text',
                            'name'  => 'agePatient',
                            'id'    => 'agePatient',
                            'value' => set_value('agePatient', $ambulance->agePatient),
                            'placeholder' => "Age du patient",
                            'class' => 'form-control',
                        ];

                        echo form_input($agePatient);
                        ?>
                        <?= !empty(validation_show_error('agePatient')) ? "<p class='text-danger'>" . validation_show_error('agePatient') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Diagnostic <font color='red'>*</font>"); ?>

                        <?php
                        $diagnostic = [
                            'type'  => 'text',
                            'name'  => 'diagnostic',
                            'id'    => 'diagnostic',
                            'value' => set_value('diagnostic', $ambulance->diagnostic),
                            'placeholder' => "Diagnostic",
                            'class' => 'form-control',
                        ];

                        echo form_input($diagnostic);
                        ?>
                        <?= !empty(validation_show_error('diagnostic')) ? "<p class='text-danger'>" . validation_show_error('diagnostic') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Evacuation <font color='red'>*</font>"); ?>
                        <?php
                        echo form_dropdown('modeEvacuationId', $modeEvacuations, set_value('modeEvacuationId', $ambulance->modeEvacuationId), "class = 'form-control' id='modeEvacuationId'");
                        ?>
                    </div>

                    <div class="col-md-3" id='divCout'>
                        <?= form_label("Payant (préciser le coût)<font color='red'>*</font>"); ?>

                        <?php
                        $coutServiceAmbulance = [
                            'type'  => 'text',
                            'name'  => 'coutServiceAmbulance',
                            'id'    => 'coutServiceAmbulance',
                            'value' => set_value('coutServiceAmbulance', $ambulance->coutServiceAmbulance),
                            'placeholder' => "Coût",
                            'class' => 'form-control',
                        ];

                        echo form_input($coutServiceAmbulance);
                        ?>
                        <?= !empty(validation_show_error('coutServiceAmbulance')) ? "<p class='text-danger'>" . validation_show_error('coutServiceAmbulance') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Dépenses liées à l’évacuation<font color='red'>*</font>"); ?>

                        <?php
                        $coutDepense = [
                            'type'  => 'text',
                            'name'  => 'coutDepense',
                            'id'    => 'coutDepense',
                            'value' => set_value('coutDepense', $ambulance->coutDepense),
                            'placeholder' => "Dépenses liées à l’évacuation",
                            'class' => 'form-control',
                        ];

                        echo form_input($coutDepense);
                        ?>
                        <?= !empty(validation_show_error('coutDepense')) ? "<p class='text-danger'>" . validation_show_error('coutDepense') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Date de retour <font color='red'>*</font>"); ?>
                        <?php $date = $ambulance->dateRetour ? $ambulance->dateRetour : set_value('dateRetour') ?>
                        <div class="input-group date" id="dateRetour" data-target-input="nearest">
                            <?= form_input('dateRetour', $date, "class='form-control datetimepicker-input', id='dateRetour' placeholder='Date de retour'") ?>
                            <div class="input-group-append" data-target="#dateRetour" data-toggle="datetimepicker">
                                <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                            </div>
                        </div>
                        <?= !empty(validation_show_error('dateRetour')) ? "<p class='text-danger'>" . validation_show_error('dateRetour') . "</p>" : "" ?>

                    </div>

                    <div class="col-md-1 mt-4">
                        <?php
                        echo form_submit("mysubmit", lang("Params.btn_save"), "class='btn btn-primary btn-sm mt-1'");
                        ?>
                    </div>
                </div>
                <?php echo form_close(); ?>

                <?php if ($ambulance->id) { ?>
                    <h5>Ajouter le staff médical</h5>

                    <?php echo form_open($locale . $routeStaff, NULL, ['ambulanceId' => (string)$ambulance->id]); ?>
                    <div class="row">

                        <div class="col-md-3">
                            <?= form_label("Staff médical<font color='red'>*</font>"); ?>
                            <?php
                            echo form_dropdown('typeStaffId', $staffs, set_value('typeStaffId'), "class = 'form-control' id='typeStaffId'");
                            ?>
                        </div>

                        <div class="col-md-3">
                            <?= form_label("Membre du staff<font color='red'>*</font>"); ?>

                            <?php
                            $membre = [
                                'type'  => 'text',
                                'name'  => 'membre',
                                'id'    => 'membre',
                                'value' => set_value('membre'),
                                'placeholder' => "Membre du staff",
                                'class' => 'form-control',
                            ];

                            echo form_input($membre);
                            ?>
                            <?= !empty(validation_show_error('membre')) ? "<p class='text-danger'>" . validation_show_error('membre') . "</p>" : "" ?>
                        </div>

                        <div class="col-md-1">
                            <?php
                            echo form_submit("mysubmit", lang("Params.btn_save"), "class='btn btn-primary btn-sm mt-4'");
                            ?>
                        </div>
                    </div>
                    <?php echo form_close(); ?>

                    <div class="table-responsive">

                        <?php

                        $table = new Table();

                        $template = [
                            'table_open' => '<table class="table table-bordered" id="myList">',
                        ];

                        $table->setTemplate($template);
                        $table->setHeading(["#", "STAFF", "MEMBRE", "OPTIONS"]);
                        $i = 1;
                        if ($membres) {
                            foreach ($membres as $membre) {
                                $subArray = [];
                                $subArray[] = $i;
                                $subArray[] = CommonTrait::formatData(new TypeStaff(), $membre->typeStaffId);
                                $subArray[] = $membre->membre;
                                $subArray[] = anchor($locale . "/data/ambulance/staff/" . $membre->id, "<i class='fa fa-trash'></i>", ['class' => 'text-danger']);


                                $table->addRow($subArray);
                                $i++;
                            }
                        }

                        echo $table->generate();
                        ?>
                    </div>
                <?php } ?>

            </div>
        </div>
    </section>
</div>


<?= $this->endSection(); ?>