<?php

namespace App\Traits;

trait CommonTrait
{
    public static function yesno($descr = "Option", $key = 0): array|string
    {

        $options = [
            "" => $descr,
            1 => "Oui",
            2 => "Non",
        ];

        return $key > 0 ? $options[$key] : $options;
    }

    public static function ouiNon($descr = "Option", $key = 0): array|string
    {

        $options = [
            "" => $descr,
            "OUI" => "Oui",
            "NON" => "Non",
        ];

        return $key > 0 ? $options[$key] : $options;
    }

    public static function lieuEvacuations($key = 0): array|string
    {

        $options = [
            "" => "Choix",
            "HOPITAL" => "Hôpital",
            "CDS" => "CDS"
        ];

        return $key > 0 ? $options[$key] : $options;
    }

    public static function typeEvacuations($key = 0): array|string
    {

        $options = [
            "" => "Choix",
            "1" => "Interne",
            "2" => "Externe"
        ];

        return $key > 0 ? $options[$key] : $options;
    }

    public static function categorieAssistances($key = 0): array|string
    {

        $options = [
            "" => "Choix",
            "1" => "Vivre",
            "2" => "Non Vivre"
        ];

        return $key > 0 ? $options[$key] : $options;
    }

    public static function modeEvacuations($key = 0): array|string
    {

        $options = [
            "" => "Choix",
            "1" => "Gratuit",
            "2" => "Payant"
        ];

        return $key > 0 ? $options[$key] : $options;
    }

    public static function tailleGroupe($key = 0): array|string
    {

        $options = [
            "" => "Choix",
            "PETIT" => "Petit:1-50 Personnes",
            "MOYEN" => "Moyen:51-199 Personnes",
            "GRAND" => "Grand:Plus de 200 Personnes"
        ];

        return $key > 0 ? $options[$key] : $options;
    }

    public static function categorieFormation($key = 0): array|string
    {

        $options = [
            "" => "Choix",
            "COMMERCIAL" => "Commercial",
            "COMMUNAUTAIRE" => "Communautaire"
        ];

        return $key > 0 ? $options[$key] : $options;
    }

    public static function niveauFormation($key = 0): array|string
    {

        $options = [
            "" => "Choix",
            "NATIONAL" => "National",
            "BRANCHE" => "Branche",
            "COMMUNAL" => "Communal",
            "COLLINAIRE" => "Collinaire"
        ];

        return $key > 0 ? $options[$key] : $options;
    }    

    public static function genres($gen = NULL): array|string
    {

        $genres =  [
            "" => "Choix",
            "HOMME" => "HOMME",
            "FEMME" => "FEMME",
            // "AUTRE" => "AUTRE",
            "NON_SPECIFIE" => "NON SPECIFIE",
        ];

        return $gen != "" ? $genres[$gen] : $genres;
    }

    public static function status(): array
    {

        return [
            "" => "Choix (Statut)",
            "SINGLE" => "Celibataire",
            "MARIED" => "Mariee",
            "DIVORCED" => "Divorce",
            "VEUF" => "Veuf(ve)",
            "CONC" => "Concubinage/Union libre",
        ];
    }

    public static function estStaff($key = 0): array|string
    {

        $options = [
            "" => "Choix",
            "OUI" => "OUI",
            "NON" => "NON",
            "ANCIEN" => "ANCIEN",
        ];

        return $key > 0 ? $options[$key] : $options;
    }

    public static function getData($instanceModel, $id)
    {
        if ($id) {
            return $instanceModel->find($id);
        }
        return $instanceModel->findAll();
    }

    public static function formatData($instanceModel, $id = 0)
    {
        $data = self::getData($instanceModel, $id);
        $array = NULL;
        if ($data) {
            if ($id) {
                $array = $data->description;
            } else {
                $array[] = " - Sélectionner - ";
                // $array[1000] = "Indéfini";

                foreach ($data as $value) {
                    $array[$value->id] = $value->description;
                }
            }
        }

        return $array;
    }

    public static function getYears()
    {
        $year = date("Y");

        $arrayYears = [];
        $arrayYears[] = " - Selectionner - ";

        for ($i = -5; $i < 8; $i++) {
            $y = $year - $i;
            $arrayYears[$y] = $y;
        }
     
        return $arrayYears;
    }
}
