<?php

namespace Modules\Volontaire\Database\Migrations;

use CodeIgniter\Database\Migration;

class Documents extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 5,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'type' => [
                'type'       => 'VARCHAR',
                'constraint' => '200',
                'default' => NULL,
            ],
            'documentPath' => [
                'type'       => 'VARCHAR',
                'constraint' => '200',
                'default' => NULL,
            ],            
            'userId' => [
                'type'       => 'INT',
                'constraint' => '100',
                'default' => NULL,
            ],
            'created_at DATETIME default current_timestamp',
            'updated_at DATETIME default NULL',
            'deleted_at DATETIME default NULL',
        ]);
        $this->forge->addKey('id', true);
        $this->forge->createTable('vt_documents');
    }

    public function down()
    {
        $this->forge->dropTable('vt_documents');
    }
}
