<?php

namespace Modules\Volontaire\Database\Migrations;

use CodeIgniter\Database\Migration;

class Etude extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 5,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'typeId' => [
                'type'       => 'INT',
                'constraint' => '100',
                'default' => NULL,
            ],
            'descriptionQualification' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'default' => NULL,
            ],
            'domaineEtude' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'default' => NULL,
            ],
            'institution' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'default' => NULL,
            ],
            'villeEtPays' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'default' => NULL,
            ],
            'dateDebut' => [
                'type'       => 'DATE',
                'default' => NULL,
            ],
            'dateFin' => [
                'type'       => 'DATE',
                'default' => NULL,
            ],
            'informationsComplementaire' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'default' => NULL,
            ],
            'userId' => [
                'type'       => 'INT',
                'constraint' => '100',
                'default' => NULL,
            ],
            'created_at DATETIME default current_timestamp',
            'updated_at DATETIME default NULL',
            'deleted_at DATETIME default NULL',
        ]);
        $this->forge->addKey('id', true);
        $this->forge->createTable('vt_etudes');
    }

    public function down()
    {
        $this->forge->dropTable('vt_etudes');
    }
}
