<?php

namespace Modules\Volontaire\Database\Migrations;

use CodeIgniter\Database\Migration;

class Volontaire extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 5,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'titre' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'default'    => NULL,
            ],
            'nom' => [
                'type'       => 'VARCHAR',
                'constraint' => '100',
                'default'    => NULL
            ],
            'prenom' => [
                'type'       => 'VARCHAR',
                'constraint' => '100',
                'default'    => NULL
            ],
            'telephone' => [
                'type'       => 'VARCHAR',
                'constraint' => '100',
                'default'    => NULL
            ],
            'email' => [
                'type'       => 'VARCHAR',
                'constraint' => '100',
                'default'    => NULL
            ],
            'surnom' => [
                'type'       => 'VARCHAR',
                'constraint' => '100',
                'default'    => NULL
            ],
            'genre' => [
                'type'       => 'ENUM',
                'constraint' => ['HOMME', 'FEMME','AUTRE','NON SPECIFIE'],
                'default'    => 'NON SPECIFIE',
            ],
            'dateNaissance' => [
                'type'       => 'DATE',
                'default'    => NULL
            ],            
            'nationaliteId' => [
                'type'       => 'INT',
                'constraint' => '100',
                'default'    => NULL,
            ],            
            'professionId' => [
                'type'       => 'INT',
                'constraint' => '11',
                'default'    => NULL,
            ], 
            'fonction' => [
                'type'       => 'VARCHAR',
                'constraint' => '100',
                'default'    => NULL,
            ], 
               'employeur' => [
                'type'       => 'VARCHAR',
                'constraint' => '100',
                'default'    => NULL,
            ],         
            'estStaff' => [
                'type'       => 'ENUM',
                'constraint' => ['OUI','NON','ANCIEN'],
                'default'    => 'NON',
            ],                   
            'passportImagePath' => [
                'type'       => 'VARCHAR',
                'constraint' => '100',
                'default' => NULL,
            ],            
            'brancheId' => [
                'type'       => 'INT',
                'default'    => NULL
            ],
            'communeId' => [
                'type'       => 'INT',
                'default'    => NULL
            ],
            'zoneId' => [
                'type'       => 'INT',
                'default'    => NULL
            ],
            'collineId' => [
                'type'       => 'INT',
                'default'    => NULL
            ],
            'userId' => [
                'type'       => 'INT',
                'default'    => NULL
            ],
            'estSectionJeunesse' => [
                'type'       => 'INT',
                'default'    => NULL
            ],
           'sectionJeunesse' => [
                'type'       => 'VARCHAR',
                'constraint' => '100',
                'default' => NULL,
            ],  
            'created_at DATETIME default current_timestamp',
            'updated_at DATETIME default NULL',
            'deleted_at DATETIME default NULL',
        ]);
        $this->forge->addKey('id', true);
        $this->forge->createTable('vt_volontaires');
    }

    public function down()
    {
        $this->forge->dropTable('vt_volontaires');        
    }
}
