<?php

namespace Modules\Volontaire\Controllers;

use App\Controllers\BaseController;
use App\Traits\EducationTrait;

use CodeIgniter\HTTP\ResponseInterface;
use Modules\Volontaire\Models\Etude as ModelsEtude;

class Etude extends BaseController
{
    
    public function index()
    {
        $this->viewData['url_list'] = "";
        $this->viewData['js'] = "";

        $etudes = (new ModelsEtude())->where('userId', \auth()->user()->id)->findAll();
        $this->viewData['etudes'] = $etudes;
        $this->viewData['types'] = EducationTrait::types();

        return view('volonatire/etude/index', $this->viewData);
    }

    function add(){
        $this->viewData['url_list'] = "";
        $this->viewData['js'] = "";
        $this->viewData['types'] = EducationTrait::types();

        return view('volonatire/etude/add', $this->viewData); 
    }

    
    public function save()
    {

        if (!$this->validate($this->valideForm())) {
            $this->viewData['url_list'] = "";
            $this->viewData['js'] = "";
            $this->viewData['types'] = EducationTrait::types();

        return view('volonatire/etude/add', $this->viewData); 
        } else {
           $stmnt = (new ModelsEtude())->save($this->etude());
            
            if ($stmnt) {
                $this->session->setFlashdata('message', "<alert class='ml-2 alert alert-success'>Niveau d'éducation supprimé avec succès</alert>");
                return redirect()->to(site_url($this->viewData['locale'] . '/volontaire/etudes'));
            }
        }
    }


    private function etude()
    {
       $etude = [];

        $etude['typeId'] = $this->request->getPost('typeId');
        $etude['descriptionQualification'] = $this->request->getPost('descriptionQualification');
        $etude['domaineEtude'] = $this->request->getPost('domaineEtude');
        $etude['institution'] = $this->request->getPost('institution');
        $etude['villeEtPays'] = $this->request->getPost('villeEtPays');
        $etude['dateDebut'] = $this->request->getPost('dateDebut');
        $etude['dateFin'] = $this->request->getPost('dateFin');
        $etude['informationsComplementaire'] = $this->request->getPost('informationsComplementaire');
        $etude['userId'] = \auth()->user()->id;

        return $etude;
    }

    private function valideForm()
    {
        $rules = [];
        $rules['typeId']      = ['rules'  => 'required'];
        $rules['descriptionQualification']     = ['rules'  => 'required'];
        $rules['institution']     = ['rules'  => 'required'];
        $rules['domaineEtude']     = ['rules'  => 'required'];
        $rules['dateDebut']     = ['rules'  => 'required'];

        return $rules;
    }

    function delete()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $stmnt = (new ModelsEtude())->delete($id);

        if ($stmnt) {
            $this->session->setFlashdata('message', "<alert class='ml-2 alert alert-success'>Niveau d'éducation supprimé avec succès</alert>");
            return redirect()->to(site_url($this->viewData['locale'] . '/volontaire/etudes'));
        }
    }
}
