<?php

namespace Modules\Volontaire\Config;

// Create a new instance of our RouteCollection class.
$routes->group("{locale}/volontaire", ["namespace" => "\Modules\Volontaire\Controllers", 'filter' => ['appAuth']], function ($routes) {
    //Routes for dashboard
    $routes->get("dash", "Dashboard::index");
    $routes->get("dash/(:num)", "Dashboard::index");

    //Routes for volontary
    $routes->get("identite", "Volontaire::index");
    $routes->post("identite/photo", "Volontaire::photo");
    $routes->get("identite/pdf", "Volontaire::pdf");
    $routes->post("save", "Volontaire::save");
    $routes->get("/", "Volontaire::list");
    $routes->post("data", "Volontaire::fecth");
    $routes->get("export/(:num)", "Volontaire::export");

    
    //Routes for languages
    $routes->get("language", "Language::index");
    $routes->post("language/save", "Language::save");
    $routes->post("language/edit", "Language::edit");
    $routes->get("language/delete/(:num)", "Language::delete");

    //Routes for etudes
    $routes->get("etudes", "Etude::index");
    $routes->get("etude", "Etude::add");
    $routes->post("etude/save", "Etude::save");
    $routes->post("etude/edit", "Etude::edit");
    $routes->get("etude/delete/(:num)", "Etude::delete");

    //Routes for experiences
    $routes->get("experiences", "Experience::index");
    $routes->get("experience", "Experience::add");
    $routes->get("experience/(:num)", "Experience::add");
    $routes->post("experience/save", "Experience::save");
    $routes->post("experience/edit", "Experience::edit");
    $routes->get("experience/delete/(:num)", "Experience::delete");

    //Routes for documents
    $routes->get("document", "Documents::index");
    $routes->post("document", "Documents::add");
    $routes->get("document/delete/(:num)", "Documents::delete");

});