<?php

namespace Modules\Params\Controllers;

use App\Controllers\BaseController;
use App\Libraries\DatatableQuery;
use App\Traits\CommonTrait;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Modules\Params\Models\CommuneModel;
use Modules\Params\Models\ZoneModel;
use Psr\Log\LoggerInterface;
use stdClass;

class ZoneController extends BaseController
{
    protected ZoneModel $zoneModel;
    protected CommuneModel $communeModel;

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);
        $this->zoneModel = new ZoneModel();
        $this->communeModel = new CommuneModel();
    }
    public function index()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(4);

        $zone =  $this->initZone($id);

        $this->viewData['url_list'] = "/params/zone/data";
        $this->viewData['js'] = "";
        $this->viewData['route'] = "/params/zone/save";
        $this->viewData['zone'] =  $zone;
        $this->viewData['communes'] = CommonTrait::formatData($this->communeModel);

        return view('params/zone/add', $this->viewData);
    }

    public function save()
    {
        $id = $this->request->getPost('id');

        if (!$this->validate($this->_rules())) {
            $zone =  $this->initZone($id);

            $this->viewData['url_list'] = "/params/zone/data";
            $this->viewData['js'] = "";
            $this->viewData['route'] = "/params/zone/save";
            $this->viewData['zone'] =  $zone;
            $this->viewData['communes'] = CommonTrait::formatData($this->communeModel);

            return view('params/zone/add', $this->viewData);
        } else {

            $uneZone = $this->uneZone();
            if ($id) {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>La zone <b>" . $uneZone['description'] . "</b> a été modifiée</div>");
                $stmt = $this->zoneModel->update($id, $uneZone);
            } else {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>La zone <b>" . $uneZone['description'] . "</b> a été bien enregistrée</div>");
                $stmt = $this->zoneModel->save($uneZone);
            }

            if ($stmt) {
                return redirect()->to(site_url($this->viewData['locale'] . '/params/zone'));
            }
        }
    }


    public function delete()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $stmnt = $this->communeModel->delete($id);
        
        if ($stmnt) {
            $this->session->setFlashdata('message', "<div class='row alert alert-success'>La zone a été suprimée</div>");
            return redirect()->to(site_url($this->viewData['locale'] . '/params/zone'));
        }
        
    }

    function zones() {
        $uri = current_url(true);

        $zoneId = $uri->getSegment(5); 
        $communeId = $uri->getSegment(4);

        $output = ['zones' => $this->formatStringZones($this->zoneModel->where("communeId", $communeId)->get()->getResult(), $zoneId)];
        return $this->response->setJSON($output);
    }
    
    private function uneZone()
    {
        $zone = [];
        $zone['description'] = $this->request->getPost('description');
        $zone['communeId'] = $this->request->getPost('communeId');
        $zone['longitude'] = $this->request->getPost('longitude');
        $zone['latitude'] = $this->request->getPost('latitude');

        return $zone;
    }

    private function initZone($id = NULL)
    {
        $zone = NULL;
        if ($id) {
            $zone = $this->zoneModel->find($id);
        } else {
            $zone = new stdClass();
            $zone->id = 0;
            $zone->communeId = "";
            $zone->description = "";
            $zone->longitude = "-1.0";
            $zone->latitude = "-1.0";
        }

        return $zone;
    }

    private function _rules()
    {
        $rules = [];
        $rules['description'] = ['rules'  => 'required|min_length[2]|max_length[100]'];
        $rules['communeId'] = ['rules'  => 'required|is_natural_no_zero'];
        $rules['longitude'] = ['rules'  => 'permit_empty|decimal'];
        $rules['latitude'] = ['rules'  => 'permit_empty|decimal'];

        return $rules;
    }



    function fecth()
    {
        $search_column = ['id', 'description', 'latitude', 'longitude'];
        $order_column = ['id', 'description', 'latitude', 'longitude'];

        $fetch_data = DatatableQuery::build_query($this->zoneModel, $search_column, $order_column);
        $output = $this->formatZones($this->viewData['locale'], $fetch_data);

        return $this->response->setJSON($output);
    }

    private function formatZones($locale, $datas)
    {
        $i = 1;
        $array_data = array();
        if (!empty($datas['data'])) {
            foreach ($datas['data'] as $data) {

                $sub_array = array();

                $sub_array[] =  $i;
                $sub_array[] =  $data->description;
                $sub_array[] =  CommonTrait::formatData($this->communeModel,$data->communeId);
                $sub_array[] =  $data->latitude;
                $sub_array[] =  $data->longitude;
                $option = "-";
                // if (\auth()->user()->inGroup('hr', 'admin') || (\auth()->user()->hasPermission('params.edit') && \auth()->user()->hasPermission('params.delete'))) {
                $option = anchor($locale . "/params/zone/" . $data->id, "<i class='fa fa-edit'></i>", ['class' => 'text-info']) . " " 
                        . anchor($locale . "/params/zone/delete/" . $data->id, "<i class='fa fa-trash'></i>", ['class' => 'text-danger']);
                //}
                $sub_array[] = $option;

                $array_data[] = $sub_array;
                $i++;
            }
        }

        return [
            "draw" => intval($_POST["draw"]),
            "recordsTotal" => $datas['recordsTotal'],
            "recordsFiltered" => $datas['recordsFiltered'],
            "data" => $array_data
        ];
    }
    

    private static function formatStringZones($zones, $zoneId){
        $options = "<option value='0'>Choix (zone)</option>";

        foreach ($zones as $zone) {
            # code...
            $selected = $zone->id == $zoneId?"selected":"";
            $options .= "<option $selected value='".$zone->id."'>".$zone->description."</option>";
        }

        return $options;
    }
}
