<?php

namespace Modules\Params\Controllers;

use App\Controllers\BaseController;
use App\Libraries\DatatableQuery;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Modules\Params\Models\TypeAssistanceModel;
use Psr\Log\LoggerInterface;
use stdClass;

class TypeAssistanceController extends BaseController
{
    public TypeAssistanceModel $typeAssistanceModel;
    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);
        $this->typeAssistanceModel = new TypeAssistanceModel();
    }

    public function index()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(4);

        $this->viewData['url_list'] = "/params/typeAssistance/data";
        $this->viewData['js'] = "";
        $this->viewData['route'] = "/params/typeAssistance/save";
        $this->viewData['typeAssistance'] =  $this->initTypeAssistance($id);

        return view('params/typeAssistance/add', $this->viewData);
    }

    public function save()
    {
        $id = $this->request->getPost('id');

        if (!$this->validate($this->_rules())) {

            $this->viewData['url_list'] = "/params/typeAssistance/data";
            $this->viewData['js'] = "";
            $this->viewData['route'] = "/params/typeAssistance/save";
            $this->viewData['typeAssistance'] =  $this->initTypeAssistance($id);

            return view('params/typeAssistance/add', $this->viewData);
        } else {

            $unTypeAssistance = $this->unTypeAssistance();
            if ($id) {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>Un type d'assistance <b>" . $unTypeAssistance['description'] . "</b> a été modifiée</div>");
                $stmt = $this->typeAssistanceModel->update($id, $unTypeAssistance);
            } else {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>Un type d'assistance <b>" . $unTypeAssistance['description'] . "</b> a été bien enregistrée</div>");
                $stmt = $this->typeAssistanceModel->save($unTypeAssistance);
            }

            if ($stmt) {
                return redirect()->to(site_url($this->viewData['locale'] . '/params/typeAssistance'));
            }
        }
    }


    public function delete()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $stmnt = $this->typeAssistanceModel->delete($id);
        
        if ($stmnt) {
            $this->session->setFlashdata('message', "<div class='row alert alert-success'>Un type d'assistance a été suprimée</div>");
            return redirect()->to(site_url($this->viewData['locale'] . '/params/typeAssistance'));
        }
        
    }

    private function unTypeAssistance()
    {
        $typeAssistance = [];
        $typeAssistance['description'] = $this->request->getPost('description');

        return $typeAssistance;
    }

    private function initTypeAssistance($id = NULL)
    {
        $typeAssistance = NULL;
        if ($id) {
            $typeAssistance = $this->typeAssistanceModel->find($id);
        } else {
            $typeAssistance = new stdClass();
            $typeAssistance->id = 0;
            $typeAssistance->description = "";
        }

        return $typeAssistance;
    }

    private function _rules()
    {
        $rules = [];
        $rules['description'] = ['rules'  => 'required|min_length[2]|max_length[100]'];

        return $rules;
    }



    function fecth()
    {
        $search_column = ['id', 'description'];
        $order_column = ['id', 'description'];

        $fetch_data = DatatableQuery::build_query($this->typeAssistanceModel, $search_column, $order_column);
        $output = $this->formatTypeAssistance($this->viewData['locale'], $fetch_data);

        return $this->response->setJSON($output);
    }

    private function formatTypeAssistance($locale, $datas)
    {
        $i = 1;
        $array_data = array();
        if (!empty($datas['data'])) {
            foreach ($datas['data'] as $data) {

                $sub_array = array();

                $sub_array[] =  $i;
                $sub_array[] =  $data->description;
                $option = "-";
                if (\auth()->user()->inGroup('hr', 'admin') || (\auth()->user()->hasPermission('params.edit') && \auth()->user()->hasPermission('params.delete'))) {
                $option = anchor($locale . "/params/typeAssistance/" . $data->id, "<i class='fa fa-edit'></i>", ['class' => 'text-info']) . " " 
                        . anchor($locale . "/params/typeAssistance/delete/" . $data->id, "<i class='fa fa-trash'></i>", ['class' => 'text-danger']);
                }
                $sub_array[] = $option;

                $array_data[] = $sub_array;
                $i++;
            }
        }

        return [
            "draw" => intval($_POST["draw"]),
            "recordsTotal" => $datas['recordsTotal'],
            "recordsFiltered" => $datas['recordsFiltered'],
            "data" => $array_data
        ];
    }
}
