<?php

namespace Modules\PS\Database\Migrations;

use CodeIgniter\Database\Migration;

class CouvertureSanitaireMigration extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'constraint' => 5,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ],

            'brancheId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'communeId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'activite' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
                'default'    => NULL,
            ],
            'dateEvenement' => [
                'type' => 'DATE',
                'default'    => NULL,
            ],
            'partenaireOrganisation' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
                'default'    => NULL,
            ],
            'personneRassamblant' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
                'default'    => NULL,
            ],
            'nbSecouriste' => [
                'type' => 'INT',
                'constraint' => '11',
            ], 
            'hommeSecouru' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],            
            'femmeSecouru' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'hommeEvacue' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'femmeEvacue' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'lieuEvacuation' => [
                'type'       => 'ENUM',
                'constraint' => ['HOPITAL', 'CDS'],
                'default'    => NULL,
            ],
            'hommeDECES' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'femmeDECES' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'nbHemorragieGrave' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'nbUrgenceInconscience' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'nbAVC' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'nbUrgCasUrg' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'nbUrgAvalSuff' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'nbUrgDoulPoitrin' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'nbUrgEmpoison' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'nbUrgAccouchement' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'nbBlessBlessurePeau' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'nbBlessSaignementNez' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'nbBlessBrulure' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'nbBlessPiqureMorsure' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'nbBlessBlessureMuscule' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'nbBlessArticulMembre' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'nbBlessBlessureTete' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'nbBlessCou' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'nbBlessDos' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'nbBlessBlessureYeux' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'nbBlessAutre' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],

            'nbMaladieEvan' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'nbMaladieFievre' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'nbMaladieConvul' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'nbMaladieDiarrhe' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'nbMaladieErupt' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'nbMaladieAutre' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'userId' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'created_at DATETIME default current_timestamp',
            'updated_at DATETIME default NULL',
            'deleted_at DATETIME default NULL',
        ]);

        $this->forge->addKey('id', true);
        $this->forge->createTable('ps_couverture_sanitaire');
    }

    public function down()
    {
        $this->forge->dropTable('ps_couverture_sanitaire');        
    }
}
