<?php

namespace Modules\PS\Controllers;

use App\Controllers\BaseController;
use App\Libraries\DatatableQuery;
use App\ThirdParty\fpdf\PdfModel;
use App\Traits\CommonTrait;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use DateTime;
use Modules\Params\Models\BrancheModel;
use Modules\Params\Models\CommuneModel;
use Modules\Params\Models\TypePremierSecourModel;
use Modules\PS\Models\FormationsMembresModel;
use Modules\PS\Models\FormationsModel;
use Psr\Log\LoggerInterface;
use stdClass;
use UConverter;

class FormationsMembresController extends BaseController
{
    public FormationsMembresModel $membresMembresModel;
    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);
        $this->membresMembresModel = new FormationsMembresModel();
    }

    public function initMembre()
    {

        $membre = new stdClass();
        $membre->formationId = 0;
        $membre->nomParticipant = '';
        $membre->prenomParticipant = '';
        $membre->cniParticipant = '';
        $membre->dateNaissance = NULL;
        $membre->sexe = NULL;
        $membre->telephone = '';
        $membre->brancheResidenceId = 0;
        $membre->communeResidenceId = 0;
        $membre->certificat = NULL;

        return $membre;
    }

    public function ajouterMembre()
    {
        $id = $this->request->getPost('formationId');

        if (!$this->validate($this->_rules())) {

            $this->viewData['url_list'] = "/ps/formations/data";
            $this->viewData['js'] = "Volontaire.js";
            $this->viewData['route'] = "/ps/formations/save";
            $this->viewData['formation'] =  (new FormationsController)->initFormation($id);
            $this->viewData['branches'] = CommonTrait::formatData(new BrancheModel());
            $this->viewData['certificats'] = CommonTrait::ouiNonte ();
            $this->viewData['niveaux'] = CommonTrait::niveauFormation();
            $this->viewData['categories'] = CommonTrait::categorieFormation();
            $this->viewData['types'] = CommonTrait::formatData(new TypePremierSecourModel());
            if ($id > 0)
                $title = "Editer une formation";
            else
                $title = "Nouvelle formation";

            $this->viewData['title'] = $title;


            return view('ps/formations/add', $this->viewData);
        } else {

            $uneMembre = $this->uneMembre();
            $this->session->setFlashdata('message', "<div class='row alert alert-success'>La formation  a été bien enregistrée</div>");
            $stmt = $this->membresMembresModel->save($uneMembre);


            if ($stmt) {
                return redirect()->to(site_url($this->viewData['locale'] . '/ps/formations/add/'.$id));
            }
        }
    }


    public function supprimerMembre()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);
        $formationId = $uri->getSegment(6);

        $stmnt = $this->membresMembresModel->delete($id);

        if ($stmnt) {
            $this->session->setFlashdata('message', "<div class='row alert alert-success'>La formation a été suprimée</div>");
            return redirect()->to(site_url($this->viewData['locale'] . '/ps/formations/add/'.$formationId));
        }
    }

    private function uneMembre()
    {
        $membre = [];
        $membre['formationId'] = $this->request->getPost('formationId');
        $membre['nomParticipant'] = $this->request->getPost('nomParticipant');
        $membre['prenomParticipant'] = $this->request->getPost('prenomParticipant');
        $membre['cniParticipant'] = $this->request->getPost('cniParticipant');
        $membre['dateNaissance'] = $this->request->getPost('dateNaissance');
        $membre['sexe'] = $this->request->getPost('sexe');
        $membre['telephone'] = $this->request->getPost('telephone');
        $membre['brancheResidenceId'] = $this->request->getPost('brancheResidenceId');
        $membre['communeResidenceId'] = $this->request->getPost('communeResidenceId');
        $membre['certificat'] = $this->request->getPost('certificat');
        $membre['userId'] = \auth()->user()->id;

        return $membre;
    }



    private function _rules()
    {
        $rules = [];
        $rules['formationId'] = ['rules'  => 'required'];
        $rules['nomParticipant'] = ['rules'  => 'required'];
        $rules['prenomParticipant'] = ['rules'  => 'required'];
        // $rules['cniParticipant'] = ['rules'  => 'required'];
        $rules['sexe'] = ['rules'  => 'required'];
        $rules['telephone'] = ['rules'  => 'required|decimal'];
        $rules['brancheResidenceId'] = ['rules'  => 'required'];
        $rules['communeResidenceId'] = ['rules'  => 'required'];
        $rules['certificat'] = ['rules'  => 'required'];

        return $rules;
    }


    function certificat()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $pdf = new PdfModel();

        $membre = $this->membresMembresModel->where('id', $id)->first();
        $formation = (new FormationsModel())->find($membre->formationId);

        $nom = isset($membre->nomParticipant) ? $membre->nomParticipant : "-";
        $prenom = isset($membre->prenomParticipant) ? $membre->prenomParticipant : "-";
        $dateFormation = new DateTime($formation->dateFormation);

        $pdf->AliasNbPages();
        $pdf->SetAutoPageBreak(1, 13);
        $pdf->AddPage('L');
        $this->response->setHeader('Content-Type', 'application/pdf');        
        $pdf->Ln(10);

        $pdf->SetFont('Times', 'B', 20);
        $pdf->Cell(270, 20, $this->formatText("CERTIFICAT DE SECOURISTE "), 0, 1, 'C');
        $pdf->SetFont('Times', '', 14);
        $pdf->Cell(270, 6, $this->formatText("La Croix-Rouge du Burundi certifie que: "), '', 1, 'C');
        $pdf->SetFont('Times', 'B', 14);
        $pdf->Cell(270, 6, $this->formatText("Mr $nom $prenom"), '', 1, 'C');
        $pdf->Ln(4);

        $pdf->SetFont('Times', '', 14);
        $pdf->Cell(70, 6, "", '', 0, 'L');
        $pdf->Cell(200, 6, $this->formatText("a suivi et reussi avec succes la formation complete des Premiers secours"), '', 1, 'L');

        $pdf->Cell(70, 6,"", "", 0, 'L');
        $pdf->Cell(45, 6, $this->formatText("Apprentissage Mixte "), '', 0, 'L');
        $pdf->SetFont('Times', 'B', 14);
        $pdf->Cell(140, 6, $this->formatText("\"$formation->intituleFormation\"."), '', 1, 'L');
        $pdf->Ln(4);

        $pdf->SetFont('Times', '', 14);
        $pdf->Cell(70, 6, "", "", 0, 'L');
        $pdf->Cell(220, 6, $this->formatText("Les pratiques et l'evaluation des competences ont ete faites le ".$dateFormation->format('d M Y'))." .", '', 1, 'L');
        $pdf->Ln(10);        

        $pdf->Cell(70, 6, "", "", 0, 'L');
        $pdf->Cell(100, 6, $this->formatText("Dr Desire HABONIMANA"), "", 0, 'L');
        $pdf->Cell(70, 6, $this->formatText("Bujumbura, le .../.../".date('Y')), "", 1, 'L');

        $pdf->Cell(70, 6, "", "", 0, 'L');
        $pdf->Cell(100, 6, $this->formatText("Expert en Premiers secours"), "", 0, 'L');
        $pdf->Cell(70, 6, $this->formatText("La Croix-Rouge du Burundi"), "", 1, 'L');
        $pdf->Ln(3);

        $pdf->Cell(70, 6, "", "", 0, 'L');
        $pdf->Cell(100, 6, $this->formatText("------------------------------------"), "", 0, 'L');
        $pdf->Cell(70, 6, $this->formatText("Anselme KATIYUNGURUZA"), "", 1, 'L');

        $pdf->Cell(70, 6, "", "", 0, 'L');
        $pdf->Cell(100, 6, $this->formatText("No ..../..../.../".date('Y')), " ", 0, 'L');
        $pdf->Cell(70, 6, $this->formatText("Secretaire General"), "", 1, 'C');

        $fileName = $this->formatText("identite/certificat_ps_" . $nom . "_" . $prenom . ".pdf");
        $pdf->Output($fileName, 'F');
        $pdf->Output();
    }

    function formatText($string = NULL)
    {
        if (gettype($string) == "string") {
            $string = UConverter::transcode($string, 'ISO-8859-1', 'UTF8');
        }

        if (gettype($string) == "array") {
            foreach ($string as $key => $value) {
                $string[$key] = UConverter::transcode($value, 'ISO-8859-1', 'UTF8');
            }
        }

        return $string;
    }
    
}
