<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <h2 class="text-bold"><?= \auth()->user()->nom . ", " . \auth()->user()->prenom ?></h2>

        <div class="row" style="margin-top:10px">

            <div class="col-md-9">
                <?php if (!empty(session()->getFlashdata('message'))) {
                    echo "<div class='row'>" . session()->getFlashdata('message')."</div>";
                } ?>
                <div class="card card-default">
                    <div class="card-header">
                        <h3 class="card-title text-bold">
                            Mes expériences
                        </h3>
                    </div>
                    <div class="card-body">
                        <?php

                        use App\Traits\ExperienceTrait;

                        if (!empty($experiences)) {
                            foreach ($experiences as $experience) {
                                // $position = $experience->position;
                                $position = $experience->position != "" ? ", " . ExperienceTrait::positions($experience->position) : " ";
                                // $domaine = $experience->domaine != "" ? ", " . ExperienceTrait::domaines($experience->domaine) : " ";

                                $each_experience = $experience->employeur . $position  . "(" . $experience->dateDebut . " au " . $experience->dateFin . ")";
                        ?>
                                <div class="row">

                                    <div class="col-md-9">
                                        <?php echo anchor($locale . "/volontaire/experience/" . $experience->id, $each_experience, '') ?>
                                    </div>

                                    <div class="col-md-3">
                                        <?php echo anchor($locale . "/volontaire/experience/delete/" . $experience->id, 'Supprimer', "class='btn btn-danger btn-sm mt-2'"); ?>
                                    </div>

                                </div>

                        <?php }
                        } ?>
                    </div>

                </div>
            </div>

            <div class="col-md-3">
                <?php echo anchor($locale . "/volontaire/experience", 'Ajouter', "class='btn btn-primary btn-sm mt-2'"); ?>
            </div>

    </section>
</div>

<?= $this->endSection(); ?>