<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <div class="card card-info card-outline">
            <div class="card-header">
                <h3 class="card-title text-bold"><?= $title ?></h3>

                <span class="float-right">
                    <?= anchor($locale . "/data/etat", "<i class='fa fa-tasks'></i> " . lang("Params.btn_list"), ['class' => 'btn btn-primary btn-sm']) ?>
                </span>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php
                    if (!empty(session()->getFlashdata('message'))) {
                        echo session()->getFlashdata('message');
                    }
                    
                    ?>
                </div>

                <?php echo form_open_multipart($locale . $route, NULL, ['id' => (string)$etat->id]); ?>
                <div class="row mb-3">
                    
                    <?php

                    $br = [
                        'type'  => 'hidden',
                        'name'  => 'branche_id_load',
                        'id'    => 'branche_id_load',
                        'value' => $etat->brancheId,
                    ];

                    echo form_input($br);

                    $cm = [
                        'type'  => 'hidden',
                        'name'  => 'commune_id_load',
                        'id'    => 'commune_id_load',
                        'value' => $etat->communeId,
                    ];

                    echo form_input($cm);                    
                    ?>

                    <div class="col-md-4">
                        <?= form_label("Province <font color='red'>*</font>"); ?>
                        <?php
                        echo form_dropdown('brancheId', $branches, set_value('brancheId', $etat->brancheId), "class = 'form-control' id='brancheId'");
                        ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Branche <font color='red'>*</font>"); ?>
                        <?php
                        echo form_dropdown('communeId', [], set_value('communeId', $etat->communeId), "class = 'form-control' id='communeId'");
                        ?>
                    </div>                    

                    <div class="col-md-4">
                    <?= form_label("Nombre de CEPV <font color='red'>*</font>"); ?>

                        <?php
                        $nbCEPV = [
                            'type'  => 'number',
                            'name'  => 'nbCEPV',
                            'id'    => 'nbCEPV',
                            'value' => set_value('nbCEPV', $etat->nbCEPV),
                            'placeholder' => "Nombre de CEPV",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbCEPV);
                        ?>
                        <?= !empty(validation_show_error('nbCEPV')) ? "<p class='text-danger'>" . validation_show_error('nbCEPV') . "</p>" : "" ?>
                    </div>
                    
                    <div class="col-md-4">
                    <?= form_label("Nbre équipe (s) de réponse PSS <font color='red'>*</font>"); ?>

                        <?php
                        $nbReponsPSS = [
                            'type'  => 'number',
                            'name'  => 'nbReponsPSS',
                            'id'    => 'nbReponsPSS',
                            'value' => set_value('nbReponsPSS', $etat->nbReponsPSS),
                            'placeholder' => "Nombre équipe (s) de réponse PSS",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbReponsPSS);
                        ?>
                        <?= !empty(validation_show_error('nbReponsPSS')) ? "<p class='text-danger'>" . validation_show_error('nbReponsPSS') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4">
                    <?= form_label("Nbre équipe (s) de réponse  PS <font color='red'>*</font>"); ?>

                        <?php
                        $nbReponsPS = [
                            'type'  => 'number',
                            'name'  => 'nbReponsPS',
                            'id'    => 'nbReponsPS',
                            'value' => set_value('nbReponsPS', $etat->nbReponsPS),
                            'placeholder' => "Nombre équipe (s) de réponse  PS",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbReponsPS);
                        ?>
                        <?= !empty(validation_show_error('nbReponsPS')) ? "<p class='text-danger'>" . validation_show_error('nbReponsPS') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4">
                    <?= form_label("Nbre équipe (s)  de réponse EPIC <font color='red'>*</font>"); ?>

                        <?php
                        $nbReponsEPIC = [
                            'type'  => 'number',
                            'name'  => 'nbReponsEPIC',
                            'id'    => 'nbReponsEPIC',
                            'value' => set_value('nbReponsEPIC', $etat->nbReponsEPIC),
                            'placeholder' => "Nombre Nombre équipe (s)  de réponse EPIC",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbReponsEPIC);
                        ?>
                        <?= !empty(validation_show_error('nbReponsEPIC')) ? "<p class='text-danger'>" . validation_show_error('nbReponsEPIC') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4">
                    <?= form_label("Nbre équipe (s) de réponse Wash <font color='red'>*</font>"); ?>

                        <?php
                        $nbReponsWASH = [
                            'type'  => 'number',
                            'name'  => 'nbReponsWASH',
                            'id'    => 'nbReponsWASH',
                            'value' => set_value('nbReponsWASH', $etat->nbReponsWASH),
                            'placeholder' => "Nombre équipe (s) de réponse Wash",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbReponsWASH);
                        ?>
                        <?= !empty(validation_show_error('nbReponsWASH')) ? "<p class='text-danger'>" . validation_show_error('nbReponsWASH') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4">
                    <?= form_label("Nbre équipe (s) de réponse Santé <font color='red'>*</font>"); ?>

                        <?php
                        $nbReponsSante = [
                            'type'  => 'number',
                            'name'  => 'nbReponsSante',
                            'id'    => 'nbReponsSante',
                            'value' => set_value('nbReponsSante', $etat->nbReponsSante),
                            'placeholder' => "Nombre équipe (s) de réponse Santé",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbReponsSante);
                        ?>
                        <?= !empty(validation_show_error('nbReponsSante')) ? "<p class='text-danger'>" . validation_show_error('nbReponsSante') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4">
                    <?= form_label("Nbre  équipe (s) de réponse gestion pacifique des conflits  <font color='red'>*</font>"); ?>

                        <?php
                        $nbReponsConflit = [
                            'type'  => 'number',
                            'name'  => 'nbReponsConflit',
                            'id'    => 'nbReponsConflit',
                            'value' => set_value('nbReponsConflit', $etat->nbReponsConflit),
                            'placeholder' => "Nombre  équipe (s) de réponse gestion pacifique des conflits ",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbReponsConflit);
                        ?>
                        <?= !empty(validation_show_error('nbReponsConflit')) ? "<p class='text-danger'>" . validation_show_error('nbReponsConflit') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4">
                    <?= form_label("Nbre unités Collinaires <font color='red'>*</font>"); ?>

                        <?php
                        $nbUniteColline = [
                            'type'  => 'number',
                            'name'  => 'nbUniteColline',
                            'id'    => 'nbUniteColline',
                            'value' => set_value('nbUniteColline', $etat->nbUniteColline),
                            'placeholder' => "Nombre unités Collinaires",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbUniteColline);
                        ?>
                        <?= !empty(validation_show_error('nbUniteColline')) ? "<p class='text-danger'>" . validation_show_error('nbUniteColline') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4">
                    <?= form_label("Effectif Adultes Masculins <font color='red'>*</font>"); ?>

                        <?php
                        $effectifAdultMascul = [
                            'type'  => 'number',
                            'name'  => 'effectifAdultMascul',
                            'id'    => 'effectifAdultMascul',
                            'value' => set_value('effectifAdultMascul', $etat->effectifAdultMascul),
                            'placeholder' => "Effectif Adultes Masculins",
                            'class' => 'form-control',
                        ];

                        echo form_input($effectifAdultMascul);
                        ?>
                        <?= !empty(validation_show_error('effectifAdultMascul')) ? "<p class='text-danger'>" . validation_show_error('effectifAdultMascul') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4">
                    <?= form_label("Effectif Adultes Féminins <font color='red'>*</font>"); ?>

                        <?php
                        $effectifAdultFemin = [
                            'type'  => 'number',
                            'name'  => 'effectifAdultFemin',
                            'id'    => 'effectifAdultFemin',
                            'value' => set_value('effectifAdultFemin', $etat->effectifAdultFemin),
                            'placeholder' => "Effectif Adultes Féminins",
                            'class' => 'form-control',
                        ];

                        echo form_input($effectifAdultFemin);
                        ?>
                        <?= !empty(validation_show_error('effectifAdultFemin')) ? "<p class='text-danger'>" . validation_show_error('effectifAdultFemin') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4">
                    <?= form_label("Effectif Jeunes Masculins <font color='red'>*</font>"); ?>

                        <?php
                        $effectifJeuneMascul = [
                            'type'  => 'number',
                            'name'  => 'effectifJeuneMascul',
                            'id'    => 'effectifJeuneMascul',
                            'value' => set_value('effectifJeuneMascul', $etat->effectifJeuneMascul),
                            'placeholder' => "Effectif Jeunes Masculins",
                            'class' => 'form-control',
                        ];

                        echo form_input($effectifJeuneMascul);
                        ?>
                        <?= !empty(validation_show_error('effectifJeuneMascul')) ? "<p class='text-danger'>" . validation_show_error('effectifJeuneMascul') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4">
                    <?= form_label("Effectif Jeunes Fémins <font color='red'>*</font>"); ?>

                        <?php
                        $effectifJeuneFemin = [
                            'type'  => 'number',
                            'name'  => 'effectifJeuneFemin',
                            'id'    => 'effectifJeuneFemin',
                            'value' => set_value('effectifJeuneFemin', $etat->effectifJeuneFemin),
                            'placeholder' => "Effectif Jeunes Fémins",
                            'class' => 'form-control',
                        ];

                        echo form_input($effectifJeuneFemin);
                        ?>
                        <?= !empty(validation_show_error('effectifJeuneFemin')) ? "<p class='text-danger'>" . validation_show_error('effectifJeuneFemin') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4">
                    <?= form_label("Nbre de volontaires vivant(s) avec handicaps (H)<font color='red'>*</font>"); ?>

                        <?php
                        $nbVolontHandicapH = [
                            'type'  => 'number',
                            'name'  => 'nbVolontHandicapH',
                            'id'    => 'nbVolontHandicapH',
                            'value' => set_value('nbVolontHandicapH', $etat->nbVolontHandicapH),
                            'placeholder' => "Nbre de volontaires vivant(s) avec handicaps (H)",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbVolontHandicapH);
                        ?>
                        <?= !empty(validation_show_error('nbVolontHandicapH')) ? "<p class='text-danger'>" . validation_show_error('nbVolontHandicapH') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4">
                    <?= form_label("Nbre de volontaires vivant(s) avec handicaps (F)<font color='red'>*</font>"); ?>

                        <?php
                        $nbVolontHandicapF = [
                            'type'  => 'number',
                            'name'  => 'nbVolontHandicapF',
                            'id'    => 'nbVolontHandicapF',
                            'value' => set_value('nbVolontHandicapF', $etat->nbVolontHandicapF),
                            'placeholder' => "Nbre de volontaires vivant(s) avec handicaps (F)",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbVolontHandicapF);
                        ?>
                        <?= !empty(validation_show_error('nbVolontHandicapF')) ? "<p class='text-danger'>" . validation_show_error('nbVolontHandicapF') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4 mb-3">
                        <?= form_label("Fichier"); ?>
                        <?php

                        $pathFile = [
                            'type'  => 'file',
                            'name'  => 'pathFile',
                            'id'    => 'pathFile',
                            'class' => 'form-control',
                        ];

                        echo form_upload($pathFile);
                        if(!empty($etat->pathFile)){
                           echo anchor(base_url()."files/etat_lieux/".$etat->pathFile, $etat->pathFile, "target='_blank'");
                        }
                        ?>                        
                    </div>

                    <div class="col-md-1 mt-4">
                        <?php
                        echo form_submit("mysubmit", lang("Params.btn_save"), "class='btn btn-primary btn-sm mt-1'");
                        ?>
                    </div>
                </div>
                <?php echo form_close(); ?>


            </div>
        </div>
    </section>
</div>


<?= $this->endSection(); ?>