<?php

namespace Modules\data\Database\Migrations;

use CodeIgniter\Database\Migration;

class EtatLieuMigration extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'constraint' => 5,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ],
            'brancheId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'communeId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'nbCEPV' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'nbReponsPSS' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            
            'nbReponsPS' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            
            'nbReponsEPIC' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'nbReponsWASH' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'nbReponsSante' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'nbReponsConflit' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'nbUniteColline' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'effectifAdultMascul' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'effectifAdultFemin' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'effectifJeuneMascul' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'effectifJeuneFemin' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'nbVolontHandicapH' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'nbVolontHandicapF' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'pathFile' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
                'default' => NULL
            ],
            'userId' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'created_at DATETIME default current_timestamp',
            'updated_at DATETIME default NULL',
            'deleted_at DATETIME default NULL',
        ]);

        $this->forge->addKey('id', true);
        $this->forge->createTable('dt_etat_lieux');
    }

    public function down()
    {
        $this->forge->dropTable('dt_etat_lieux');        
    }
}
