<?php

namespace Modules\PS\Database\Migrations;

use CodeIgniter\Database\Migration;

class FormationMigration extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'constraint' => 5,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ],
            
            'intituleFormation' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
                'default'    => NULL,
            ],

            'brancheId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'communeId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],

            'formateurUnNomPrenom' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
                'default'    => NULL,
            ],

            'formateurDeuxNomPrenom' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
                'default'    => NULL,
            ],

            'dateFormation' => [
                'type' => 'DATE',
                'default'    => NULL,
            ],

            'categorieId' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],

            'niveauId' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],

            'typeFormationId' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],

            'nomParticipant' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
                'default'    => NULL,
            ],
            'prenomParticipant' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
                'default'    => NULL,
            ],

            'cniParticipant' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
                'default'    => NULL,
            ],

            'dateNaissance' => [
                'type' => 'DATE',
                'default'    => NULL,
            ],
            'sexe' => [
                'type'       => 'ENUM',
                'constraint' => ['HOMME', 'FEMME'],
                'default'    => NULL,
            ],

            'telephone' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
                'default'    => NULL,
            ],
            'brancheResidenceId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'communeResidenceId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],

            'certificat' => [
                'type'       => 'ENUM',
                'constraint' => ['OUI', 'NON'],
                'default'    => "NON",
            ],

            'dateExpiration' => [
                'type' => 'DATE',
                'default'    => NULL,
            ],

            'userId' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'created_at DATETIME default current_timestamp',
            'updated_at DATETIME default NULL',
            'deleted_at DATETIME default NULL',
        ]);

        $this->forge->addKey('id', true);
        $this->forge->createTable('ps_formation');
    }

    public function down()
    {
        $this->forge->dropTable('ps_formation');
    }
}
