<?php

namespace Modules\Params\Controllers;

use App\Controllers\BaseController;
use App\Libraries\DatatableQuery;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Modules\Params\Models\TypeConstructionModel;
use Psr\Log\LoggerInterface;
use stdClass;

class TypeConstructionController extends BaseController
{
    public TypeConstructionModel $typeConstructionModel;
    
    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);
        $this->typeConstructionModel = new TypeConstructionModel();
    }

    public function index()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(4);

        $this->viewData['url_list'] = "/params/typeConstruction/data";
        $this->viewData['js'] = "";
        $this->viewData['route'] = "/params/typeConstruction/save";
        $this->viewData['typeConstruction'] =  $this->initTypeConstruction($id);

        return view('params/typeConstruction/add', $this->viewData);
    }

    public function save()
    {
        $id = $this->request->getPost('id');

        if (!$this->validate($this->_rules())) {

            $this->viewData['url_list'] = "/params/typeConstruction/data";
            $this->viewData['js'] = "";
            $this->viewData['route'] = "/params/typeConstruction/save";
            $this->viewData['typeConstruction'] =  $this->initTypeConstruction($id);

            return view('params/typeConstruction/add', $this->viewData);
        } else {

            $unTypeConstruction = $this->unTypeConstruction();
            if ($id) {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>Un type de construction <b>" . $unTypeConstruction['description'] . "</b> a été modifiée</div>");
                $stmt = $this->typeConstructionModel->update($id, $unTypeConstruction);
            } else {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>Un type de construction <b>" . $unTypeConstruction['description'] . "</b> a été bien enregistrée</div>");
                $stmt = $this->typeConstructionModel->save($unTypeConstruction);
            }

            if ($stmt) {
                return redirect()->to(site_url($this->viewData['locale'] . '/params/typeConstruction'));
            }
        }
    }


    public function delete()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $stmnt = $this->typeConstructionModel->delete($id);
        
        if ($stmnt) {
            $this->session->setFlashdata('message', "<div class='row alert alert-success'>Un type de construction a été suprimée</div>");
            return redirect()->to(site_url($this->viewData['locale'] . '/params/typeConstruction'));
        }
        
    }

    private function unTypeConstruction()
    {
        $typeConstruction = [];
        $typeConstruction['description'] = $this->request->getPost('description');

        return $typeConstruction;
    }

    private function initTypeConstruction($id = NULL)
    {
        $typeConstruction = NULL;
        if ($id) {
            $typeConstruction = $this->typeConstructionModel->find($id);
        } else {
            $typeConstruction = new stdClass();
            $typeConstruction->id = 0;
            $typeConstruction->description = "";
        }

        return $typeConstruction;
    }

    private function _rules()
    {
        $rules = [];
        $rules['description'] = ['rules'  => 'required|min_length[2]|max_length[100]'];

        return $rules;
    }



    function fecth()
    {
        $search_column = ['id', 'description'];
        $order_column = ['id', 'description'];

        $fetch_data = DatatableQuery::build_query($this->typeConstructionModel, $search_column, $order_column);
        $output = $this->formatTypeConstruction($this->viewData['locale'], $fetch_data);

        return $this->response->setJSON($output);
    }

    private function formatTypeConstruction($locale, $datas)
    {
        $i = 1;
        $array_data = array();
        if (!empty($datas['data'])) {
            foreach ($datas['data'] as $data) {

                $sub_array = array();

                $sub_array[] =  $i;
                $sub_array[] =  $data->description;
                $option = "-";
                if (\auth()->user()->inGroup('hr', 'admin') || (\auth()->user()->hasPermission('params.edit') && \auth()->user()->hasPermission('params.delete'))) {
                $option = anchor($locale . "/params/typeConstruction/" . $data->id, "<i class='fa fa-edit'></i>", ['class' => 'text-info']) . " " 
                        . anchor($locale . "/params/typeConstruction/delete/" . $data->id, "<i class='fa fa-trash'></i>", ['class' => 'text-danger']);
                }
                $sub_array[] = $option;

                $array_data[] = $sub_array;
                $i++;
            }
        }

        return [
            "draw" => intval($_POST["draw"]),
            "recordsTotal" => $datas['recordsTotal'],
            "recordsFiltered" => $datas['recordsFiltered'],
            "data" => $array_data
        ];
    }
}
