<?php

namespace Modules\PS\Controllers;

use App\Controllers\BaseController;
use App\Libraries\DatatableQuery;
use App\ThirdParty\fpdf\PdfModel;
use App\Traits\CommonTrait;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use DateTime;
use Modules\Params\Models\BrancheModel;
use Modules\Params\Models\CommuneModel;
use Modules\Params\Models\TypePremierSecourModel;
use Modules\PS\Models\FormationsMembresModel;
use Modules\PS\Models\FormationsModel;
use Psr\Log\LoggerInterface;
use stdClass;
use UConverter;

use function PHPUnit\Framework\fileExists;

class FormationsController extends BaseController
{
    public FormationsModel $formationModel;
    public FormationsMembresModel $formationMembreModel;
    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);
        $this->formationModel = new FormationsModel();
        $this->formationMembreModel = new FormationsMembresModel();
    }


    public function index()
    {
        $this->viewData['url_list'] = "/ps/formations/data";
        $this->viewData['js'] = "Common.js";
        $this->viewData['title'] = "Liste des formations";
        $this->viewData['branches'] = CommonTrait::formatData(new BrancheModel());

        return view('ps/formations/index', $this->viewData);
    }
    public function add()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $this->viewData['url_list'] = "";
        $this->viewData['js'] = "Volontaire.js";
        $this->viewData['route'] = "/ps/formations/save";
        $this->viewData['formation'] =  $this->initFormation($id);
        $this->viewData['branches'] = CommonTrait::formatData(new BrancheModel());
        $this->viewData['certificats'] = CommonTrait::ouiNon();
        $this->viewData['niveaux'] = CommonTrait::niveauFormation();
        $this->viewData['categories'] = CommonTrait::categorieFormation();
        $this->viewData['types'] = CommonTrait::formatData(new TypePremierSecourModel());
        $this->viewData['membre'] = (new FormationsMembresController())->initMembre();
        $this->viewData['sexes'] = CommonTrait::genres();
        $this->viewData['membres'] = (new FormationsMembresModel())->where('formationId', $id)->get()->getResult();

        if ($id > 0)
            $title = "Editer une formation";
        else
            $title = "Nouvelle formation";

        $this->viewData['title'] = $title;

        return view('ps/formations/add', $this->viewData);
    }

    public function save()
    {
        $id = $this->request->getPost('id');

        if (!$this->validate($this->_rules())) {

            $this->viewData['url_list'] = "/ps/formations/data";
            $this->viewData['js'] = "Volontaire.js";
            $this->viewData['route'] = "/ps/formations/save";
            $this->viewData['formation'] =  $this->initFormation($id);
            $this->viewData['branches'] = CommonTrait::formatData(new BrancheModel());
            $this->viewData['certificats'] = CommonTrait::ouiNon();
            $this->viewData['niveaux'] = CommonTrait::niveauFormation();
            $this->viewData['categories'] = CommonTrait::categorieFormation();
            $this->viewData['types'] = CommonTrait::formatData(new TypePremierSecourModel());
            if ($id > 0)
                $title = "Editer une formation";
            else
                $title = "Nouvelle formation";

            $this->viewData['title'] = $title;


            return view('ps/formations/add', $this->viewData);
        } else {

            $uneFormation = $this->uneFormation();

            if ($id) {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>La formation  a été modifiée</div>");
                $stmt = $this->formationModel->update($id, $uneFormation);
            } else {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>La formation  a été bien enregistrée</div>");
                $stmt = $this->formationModel->save($uneFormation);
            }

            if ($stmt) {
                return redirect()->to(site_url($this->viewData['locale'] . '/ps/formations'));
            }
        }
    }


    public function delete()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(6);

        $stmnt = $this->formationModel->delete($id);
        $stmnt = $this->formationMembreModel->where('formationId', $id)->delete();

        if ($stmnt) {
            $this->session->setFlashdata('message', "<div class='row alert alert-success'>La formation a été suprimée</div>");
            return redirect()->to(site_url($this->viewData['locale'] . '/ps/formations'));
        }
    }

    private function uneFormation()
    {
        $formation = [];
        $formation['intituleFormation'] = $this->request->getPost('intituleFormation');
        $formation['brancheId'] = $this->request->getPost('brancheId');
        $formation['communeId'] = $this->request->getPost('communeId');
        $formation['formateurUnNomPrenom'] = $this->request->getPost('formateurUnNomPrenom');
        $formation['formateurDeuxNomPrenom'] = $this->request->getPost('formateurDeuxNomPrenom');
        $formation['dateFormation'] = $this->request->getPost('dateFormation');
        $formation['categorieId'] = $this->request->getPost('categorieId');
        $formation['niveauId'] = $this->request->getPost('niveauId');
        $formation['typeFormationId'] = $this->request->getPost('typeFormationId');
        $formation['certificat'] = $this->request->getPost('certificat');
        $formation['dateExpiration'] = $this->request->getPost('dateExpiration');
        $formation['userId'] = \auth()->user()->id;

        return $formation;
    }

    public function initFormation($id = NULL)
    {
        $formation = NULL;
        if ($id) {
            $formation = $this->formationModel->find($id);
        } else {

            $formation = new stdClass();
            $formation->id = 0;
            $formation->intituleFormation = "";
            $formation->brancheId = 0;
            $formation->communeId = 0;
            $formation->formateurUnNomPrenom = '';
            $formation->formateurDeuxNomPrenom = '';
            $formation->dateFormation = '';
            $formation->categorieId = 0;
            $formation->niveauId = 0;
            $formation->typeFormationId = 0;
            $formation->certificat = NULL;
            $formation->dateExpiration = '';
        }

        return $formation;
    }

    private function _rules()
    {
        $rules = [];
        $rules['brancheId'] = ['rules'  => 'required'];
        $rules['communeId'] = ['rules'  => 'required'];
        $rules['formateurUnNomPrenom'] = ['rules'  => 'required'];
        $rules['intituleFormation'] = ['rules'  => 'required'];
        $rules['categorieId'] = ['rules'  => 'required'];
        $rules['niveauId'] = ['rules'  => 'required'];
        $rules['typeFormationId'] = ['rules'  => 'required'];
        // $rules['certificat'] = ['rules'  => 'required'];
        // $rules['dateExpiration'] = ['rules'  => 'required'];

        return $rules;
    }

    function fecth()
    {
        $search_column = ['id', 'intituleFormation', 'brancheId', 'communeId', 'formateurUnNomPrenom', 'formateurDeuxNomPrenom', 'dateFormation', 'categorieId', 'niveauId', 'typeFormationId', 'certificat', 'dateExpiration', 'userId'];
        $order_column = ['id', 'intituleFormation', 'brancheId', 'communeId', 'formateurUnNomPrenom', 'formateurDeuxNomPrenom', 'dateFormation', 'categorieId', 'niveauId', 'typeFormationId', 'certificat', 'dateExpiration', 'userId'];

        $formationMdl = $this->formationModel;
        if (\auth()->user()->inGroup('brancheManager')) {
            $formationMdl->where('brancheId', \auth()->user()->brancheId);
        }

        if (\auth()->user()->inGroup('communeManager')) {
            $formationMdl->where('communeId', \auth()->user()->communeId);
        }

        if ($this->request->getPost('brancheId') > 0) {
            $formationMdl->where('brancheId', $this->request->getPost('brancheId'));
        }

        $fetch_data = DatatableQuery::build_query($formationMdl, $search_column, $order_column);
        $output = $this->formatFormations($this->viewData['locale'], $fetch_data);

        return $this->response->setJSON($output);
    }

    private function formatFormations($locale, $datas)
    {
        $i = 1;
        $array_data = array();
        if (!empty($datas['data'])) {
            foreach ($datas['data'] as $data) {

                $sub_array = array();

                $sub_array[] =  $i;
                $sub_array[] =  $data->intituleFormation;
                $sub_array[] =  CommonTrait::formatData(new BrancheModel(), $data->brancheId);
                $sub_array[] =  CommonTrait::formatData(new CommuneModel(), $data->communeId);
                $sub_array[] =  $data->formateurUnNomPrenom . ' & ' . $data->formateurDeuxNomPrenom;
                $sub_array[] =  $data->dateFormation;
                $sub_array[] =  CommonTrait::categorieFormation($data->categorieId);
                $sub_array[] =  CommonTrait::niveauFormation($data->niveauId);
                $sub_array[] =  CommonTrait::formatData(new TypePremierSecourModel(), $data->typeFormationId);

                $option = "-";
                if (\auth()->user()->inGroup('hr', 'admin') || (\auth()->user()->hasPermission('params.edit') && \auth()->user()->hasPermission('params.delete'))) {
                    $option = anchor($locale . "/ps/formations/add/" . $data->id, "<i class='fa fa-edit'></i>", ['class' => 'text-info']) . " "
                        . anchor($locale . "/ps/formations/detail/" . $data->id, "<i class='fa fa-eye'></i>", ['target' => '_blank', 'class' => 'text-info']) . " "
                        . anchor($locale . "/ps/formations/delete/" . $data->id, "<i class='fa fa-trash'></i>", ['class' => 'text-danger']);
                }
                $sub_array[] = $option;

                $array_data[] = $sub_array;
                $i++;
            }
        }

        return [
            "draw" => intval($_POST["draw"]),
            "recordsTotal" => $datas['recordsTotal'],
            "recordsFiltered" => $datas['recordsFiltered'],
            "data" => $array_data
        ];
    }

    public function detail()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $this->viewData['url_list'] = "";
        $this->viewData['js'] = "";
        $this->viewData['formation'] = $this->formationModel->find($id);
        $this->viewData['membres'] = (new FormationsMembresModel())->where('formationId', $id)->get()->getResult();

        $this->viewData['title'] = "Detail d'une formation";

        return view('ps/formations/detail', $this->viewData);
    }

    function export()
    {
        $uri = current_url(true);
        $brancheId = $uri->getSegment(5);

        if ($brancheId > 0) {
            $branche = CommonTrait::formatData(new BrancheModel(), $brancheId);
        } else {
            $branche = "Toutes les branches";
        }

        $fileName = str_replace(' ', '', $branche);
        $csv_file_name = "rapportExport/ps_formation/ps_formation_" . $fileName . ".csv";
        $file = fopen($csv_file_name, 'w');

        $arrays = [];
        $arrays[0] = ['', $this->formatText(" Premiers Secours - Formations")];
        $arrays[1] = ['', $this->formatText($branche)];
        $arrays[2] = [];
        $arrays[3] = [
            '#',
            $this->formatText('Intitule formation'),
            $this->formatText('Branche'),
            $this->formatText('Commune'),
            $this->formatText('Formateur1 ( Nom et prénom)'),
            $this->formatText("Formateur2 ( Nom et prénom)"),
            $this->formatText("Date de formation"),
            $this->formatText("Catégorie de formation"),
            $this->formatText("Niveau de formation"),
            $this->formatText("Type de formation"),
            $this->formatText("Nom du participant"),
            $this->formatText("Prénom du Participant"),
            $this->formatText("CNI du participant"),
            $this->formatText("Date de naissance"),
            $this->formatText("Sexe (M, F)"),
            $this->formatText("Téléphone portable"),
            $this->formatText("Branche résidence"),
            $this->formatText("Branche résidence"),
            $this->formatText("Reçu certificat de formation"),
            $this->formatText("Si oui, date d'expiration du certificat (2ans  après formation)")
        ];

        if ($brancheId > 0) {
            $formations = $this->formationModel->where('brancheId', $brancheId)->findAll();
        } else {
            $formations = $this->formationModel->findAll();
        }

        $i = 1;
        foreach ($formations as $formation) {
            $membres = (new FormationsMembresModel())->where('formationId', $formation->id)->get()->getResult();
            foreach ($membres as $membre) {
                $sub_array = [];
                $sub_array[] =  $i;
                $sub_array[] =  $formation->intituleFormation;
                $sub_array[] =  CommonTrait::formatData(new BrancheModel(), $formation->brancheId);
                $sub_array[] =  CommonTrait::formatData(new CommuneModel(), $formation->communeId);
                $sub_array[] =  $formation->formateurUnNomPrenom;
                $sub_array[] =  $formation->formateurDeuxNomPrenom;
                $sub_array[] =  $formation->dateFormation;
                $sub_array[] =  CommonTrait::categorieFormation($formation->categorieId);
                $sub_array[] =  CommonTrait::niveauFormation($formation->niveauId);
                $sub_array[] =  CommonTrait::formatData(new TypePremierSecourModel(), $formation->typeFormationId);
                $sub_array[] =  $membre->nomParticipant;
                $sub_array[] =  $membre->prenomParticipant;
                $sub_array[] =  $membre->cniParticipant;
                $sub_array[] =  $membre->dateNaissance;
                $sub_array[] =  $membre->sexe;
                $sub_array[] =  $membre->telephone;
                $sub_array[] =  CommonTrait::formatData(new BrancheModel(), $membre->brancheResidenceId);
                $sub_array[] =  CommonTrait::formatData(new CommuneModel(), $membre->communeResidenceId);
                $sub_array[] =  $membre->certificat;
                $sub_array[] =  $formation->dateExpiration;

                $arrays[] = $sub_array;
                $i++;
            }
        }


        foreach ($arrays as $array) {
            fputcsv($file, $array);
        }
        fclose($file);
        $btn = anchor($csv_file_name, "Exporter un <i class='fa fa-file-csv'></i>", ['class' => 'text-success', 'target' => '_blank']);

        $status = 0;
        if (fileExists($csv_file_name)) {
            $status = 1;
        }

        return $this->response->setJSON(['status' => $status, 'btnExport' => $btn]);
    }

    function formatText($string = NULL)
    {
        if (gettype($string) == "string") {
            $string = UConverter::transcode($string, 'ISO-8859-1', 'UTF8');
        }

        if (gettype($string) == "array") {
            foreach ($string as $key => $value) {
                $string[$key] = UConverter::transcode($value, 'ISO-8859-1', 'UTF8');
            }
        }

        return $string;
    }

    function certificat()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $pdf = new PdfModel();

        $formation = $this->formationModel->where('id', $id)->first();

        $nom = isset($formation->nomParticipant) ? $formation->nomParticipant : "-";
        $prenom = isset($formation->prenomParticipant) ? $formation->prenomParticipant : "-";
        $dateFormation = new DateTime($formation->dateFormation);

        $pdf->AliasNbPages();
        $pdf->SetAutoPageBreak(1, 13);
        $pdf->AddPage('L');
        $this->response->setHeader('Content-Type', 'application/pdf');
        $pdf->Ln(10);

        $pdf->SetFont('Times', 'B', 20);
        $pdf->Cell(270, 20, $this->formatText("CERTIFICAT DE SECOURISTE "), 0, 1, 'C');
        $pdf->SetFont('Times', '', 14);
        $pdf->Cell(270, 6, $this->formatText("La Croix-Rouge du Burundi certifie que: "), '', 1, 'C');
        $pdf->SetFont('Times', 'B', 14);
        $pdf->Cell(270, 6, $this->formatText("Mr $nom $prenom"), '', 1, 'C');
        $pdf->Ln(4);

        $pdf->SetFont('Times', '', 14);
        $pdf->Cell(70, 6, "", '', 0, 'L');
        $pdf->Cell(200, 6, $this->formatText("a suivi et reussi avec succes la formation complete des Premiers secours"), '', 1, 'L');

        $pdf->Cell(70, 6, "", "", 0, 'L');
        $pdf->Cell(45, 6, $this->formatText("Apprentissage Mixte "), '', 0, 'L');
        $pdf->SetFont('Times', 'B', 14);
        $pdf->Cell(140, 6, $this->formatText("\"$formation->intituleFormation\"."), '', 1, 'L');
        $pdf->Ln(4);

        $pdf->SetFont('Times', '', 14);
        $pdf->Cell(70, 6, "", "", 0, 'L');
        $pdf->Cell(220, 6, $this->formatText("Les pratiques et l'evaluation des competences ont ete faites le " . $dateFormation->format('d M Y')) . " .", '', 1, 'L');
        $pdf->Ln(10);

        $pdf->Cell(70, 6, "", "", 0, 'L');
        $pdf->Cell(100, 6, $this->formatText("Dr Desire HABONIMANA"), "", 0, 'L');
        $pdf->Cell(70, 6, $this->formatText("Bujumbura, le .../.../" . date('Y')), "", 1, 'L');

        $pdf->Cell(70, 6, "", "", 0, 'L');
        $pdf->Cell(100, 6, $this->formatText("Expert en Premiers secours"), "", 0, 'L');
        $pdf->Cell(70, 6, $this->formatText("La Croix-Rouge du Burundi"), "", 1, 'L');
        $pdf->Ln(3);

        $pdf->Cell(70, 6, "", "", 0, 'L');
        $pdf->Cell(100, 6, $this->formatText("------------------------------------"), "", 0, 'L');
        $pdf->Cell(70, 6, $this->formatText("Anselme KATIYUNGURUZA"), "", 1, 'L');

        $pdf->Cell(70, 6, "", "", 0, 'L');
        $pdf->Cell(100, 6, $this->formatText("No ..../..../.../" . date('Y')), " ", 0, 'L');
        $pdf->Cell(70, 6, $this->formatText("Secretaire General"), "", 1, 'C');

        $fileName = $this->formatText("identite/certificat_ps_" . $nom . "_" . $prenom . ".pdf");
        $pdf->Output($fileName, 'F');
        $pdf->Output();
    }
}
