<?php

namespace Modules\Administration\Database\Migrations;

use CodeIgniter\Database\Migration;
use CodeIgniter\Database\MySQLi\Forge;

class User extends Migration
{
    /**
     * @var string[]
     */
    private array $tables;

    public function __construct(?Forge $forge = null)
    {
        parent::__construct($forge);

        /** @var \Config\Auth $authConfig */
        $authConfig   = config('Auth');
        $this->tables = $authConfig->tables;
    }

    public function up()
    {
        $fields = [
            'nom' => [
                'type' => 'VARCHAR', 
                'constraint' => '100', 
                'null' => true
            ],
            'prenom' => [
                'type' => 'VARCHAR',
                'constraint' => '100', 
                'null' => true
            ],
            'telephone' => [
                'type' => 'VARCHAR', 
                'constraint' => '20', 
                'null' => true
            ],
            'brancheId' => [
                'type' => 'INT', 
                'constraint' => 5, 
                'default' => null
            ],
            'communeId' => [
                'type' => 'INT', 
                'constraint' => 5, 
                'default' => null
            ],
            'zoneId' => [
                'type' => 'INT', 
                'constraint' => 5, 
                'default' => null
            ],
            'collineId' => [
                'type' => 'INT', 
                'constraint' => 5, 
                'default' => null
            ],
        ];
        $this->forge->addColumn($this->tables['users'], $fields);
    }

    public function down()
    {
        $fields = [
            'nom',
            'prenom',
            'telephone',
            'brancheId',
            'communeId',
            'zoneId',
            'collineId',
        ];
        $this->forge->dropColumn($this->tables['users'], $fields);
    }
}
