<?php

namespace Modules\Administration\Controllers;

use App\Controllers\BaseController;
use App\Libraries\DatatableQuery;
use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\Shield\Entities\User as EntitiesUser;
use CodeIgniter\Shield\Models\UserModel;

use Modules\Administration\Libraries\User as LibrariesUser;
use Modules\Administration\Models\User as ModelsUser;
use Modules\Administration\Traits\GroupeTrait;
use Modules\Administration\Traits\PermissionTrait;
use Modules\Volontaire\Models\Volontaire;

class User extends BaseController
{
    public function index()
    {

        $this->viewData['url_list'] = "";
        $this->viewData['js'] = "";
        $this->viewData['permissions'] = PermissionTrait::ArrayFormat(self::getPermissions());
        $this->viewData['groups'] = GroupeTrait::ArrayFormat(self::getGroups());

        return view('admin/user/add', $this->viewData);
    }

    public function add()
    {
        // Save the user
        if (!$this->validate(LibrariesUser::rules())) {
            $this->viewData['url_list'] = "";
            $this->viewData['js'] = "";
            $this->viewData['permissions'] = PermissionTrait::ArrayFormat(self::getPermissions());
            $this->viewData['groups'] = GroupeTrait::ArrayFormat(self::getGroups());

            return view('admin/user/add', $this->viewData);
        } else {
            //$stmt = $this->UserEntity(new ModelsUser())->save();
            $userObject = new UserModel();

            $response = $userObject->save($this->UserEntity());
            (new ModelsUser())->update($userObject->getInsertID(),$this->UserEntity());

            // To get the complete user object with ID, we need to get from the database
            $user = $userObject->findById($userObject->getInsertID());

            // Add to default group
            $userObject->addToDefaultGroup($user);

            // Set the user active
            $user->activate();

            //Add other groups 
            $this->addGroup($user);

            //Add other permission
            $this->addPermission($user);

            //set volontaires
            $volontaire = new Volontaire();
            $volontaire->save([
                    'userId' => $userObject->getInsertID(),
                    'prenom' => $this->request->getPost('prenom'),
                    'nom' => $this->request->getPost('nom'),
                    // 'surnom' => $this->request->getPost('username'),
                ]);

            if ($response) {
                $this->session->setFlashdata('message', "<alert class='ml-2 alert alert-success'>" . lang("Administration.user_form_created") . "</alert>");
                return redirect()->to(site_url($this->viewData['locale'] . '/admin/users'));
            }
        }
    }

    /**
     * Returns the Entity class that should be used
     */
    protected function UserEntity($id = NULL)
    {
        $user = new EntitiesUser();
        $user->id = $id;
        $user->username = $this->request->getPost('username');
        $user->prenom = $this->request->getPost('prenom');
        $user->nom = $this->request->getPost('nom');
        $user->telephone = $this->request->getPost('telephone');
        $user->email = $this->request->getPost('email');


        if ($id == NULL) {
            $user->password = $this->request->getPost('password');
        } else {
            $password = $this->request->getPost('password');
            if (!empty($password)) {
                $user->password = $password;
            }
        }

        return $user;
    }

    public function edit()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(4);

        $user = (new UserModel())->findById($id);
        $this->viewData['url_list'] = "";
        $this->viewData['js'] = "";
        $this->viewData['user'] = $user;
        $this->viewData['permissions'] = PermissionTrait::ArrayFormat(self::getPermissions());
        $this->viewData['groups'] = GroupeTrait::ArrayFormat(self::getGroups());
        $this->viewData['selectGroups'] = $user->getGroups();
        $this->viewData['selectPermissions'] = $user->getPermissions();

        return view('admin/user/edit', $this->viewData);
    }

    function saveEdit()
    {
        $userId = $this->request->getPost('id');

        $user = (new UserModel())->findById($userId);
        $this->viewData['url_list'] = "";
        $this->viewData['js'] = "";
        $this->viewData['user'] = $user;
        $this->viewData['permissions'] = PermissionTrait::ArrayFormat(self::getPermissions());
        $this->viewData['groups'] = GroupeTrait::ArrayFormat(self::getGroups());
        $this->viewData['selectGroups'] = $user->getGroups();
        $this->viewData['selectPermissions'] = $user->getPermissions();

        if (!$this->validate(LibrariesUser::rules($userId, $this->request->getPost('password')))) {
            return view('admin/user/edit', $this->viewData);
        } else {
            $userMdl = new ModelsUser();
            $response = $userMdl->update($userId, $this->UserEntity());

            // To get the complete user object with ID, we need to get from the database
            $userObject = new UserModel();
            $userObject->update($userId, $this->UserEntity($userId));
            $user = $userObject->findById($userId);

            //Add other groups 
            $this->addGroup($user, $userId);

            //Add other permission
            $this->addPermission($user, $userId);

            //set volontaires
            $volontaire = new Volontaire();
            $ancienDonnee = $volontaire->where('userId', $userId)->first();

            $volontaire->update($ancienDonnee->id,[
                    // 'userId' => $userObject->getInsertID(),
                    'prenom' => $this->request->getPost('prenom'),
                    'nom' => $this->request->getPost('nom'),
                    // 'surnom' => $this->request->getPost('username'),
                ]);

            if ($response) {
                $this->session->setFlashdata('message', "<alert class='ml-2 alert alert-success'>" . lang("Administration.user_form_uploaded") . "</alert>");
                return redirect()->to(site_url($this->viewData['locale'] . '/admin/users'));
            } else {
                return view('admin/user/edit', $this->viewData);
            }
        }
    }

    function delete()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $stmnt = (new ModelsUser())->findById($id)->delete();

        if ($stmnt) {
            $this->session->setFlashdata('message', "<alert class='ml-2 alert alert-success'>L'utilisateur a été désactivé avec succès</alert>");
            return redirect()->to(site_url($this->viewData['locale'] . '/admin/users'));
        }
    }

    function get()
    {
        $this->viewData['url_list'] = "/admin/users/data";
        $this->viewData['js'] = "";

        $this->viewData['users'] = (new ModelsUser())->findAll();

        return view('admin/user/index', $this->viewData);
    }


    function addGroup($user, $id = NULL)
    {
        $groups = $this->request->getPost('group');
        $this->removegroup($user);

        if (!empty($groups)) {
            foreach ($groups as $key => $group) {
                $user->addGroup($group);
            }
        }
    }

    private function removegroup($user)
    {
        foreach ($user->getGroups() as $key => $group) {
            $user->removeGroup($group);
        }
    }

    function addPermission($user, $id = NULL)
    {
        $permissions = $this->request->getPost('permission');

        $this->removePermission($user);

        if (!empty($permissions)) {
            foreach ($permissions as $key => $permission) {
                $user->addPermission($permission);
            }
        }
    }

    private function removePermission($user)
    {
        foreach ($user->getPermissions() as $key => $permission) {
            $user->removePermission($permission);
        }
    }

    public static function getGroups()
    {
        // print_r(config('AuthGroups')->groups);
        return config('AuthGroups')->groups;
    }

    public static function getPermissions()
    {
        return config('AuthGroups')->permissions;
    }
}
