<?php
  //Initialisatiion de session
  session_start();
  $user_id = $_SESSION['user_id'];
  $profil_id = $_SESSION['profil_id'];

  //Si l'utilisateur n-est pas connecté, on fait une redirection sur la page de connection
  if($user_id < 1){
    header('Location: ./index.php');
  }

  //Recuperation du profil de l'utilisateur connecté
  if($profil_id != 1){
    header('Location: ./projet_liste.php');
  }

//Connection a la base de donnees
  //$mysqli = new mysqli("localhost","root","","crb_care");
	include ('connexion.php');
	
 // Recuperation des profiles
  $sql_profil = "SELECT * FROM profils ORDER BY profil_descr ASC";
  $stm_profil = $mysqli->query($sql_profil);
  // Formattager des profiles recuperees sous forme tableau cle =>value
  $profils = $stm_profil->fetch_all(MYSQLI_ASSOC);

  // Id de l'utilisateur a modifier
  $collabo_id = $_GET['user_id'];
  //Recuperation de l'utilisateur a modifier
  $sql_user = "SELECT * FROM users WHERE user_id = $collabo_id";
  $stm_user = $mysqli->query($sql_user);
  // Formattager de l'utilisateur recupere sous forme tableau cle =>value
  $user = $stm_user->fetch_array(MYSQLI_ASSOC);

  //Recuperation de tous les profiles
  $sql_partenaire = "SELECT * FROM partenaires ORDER BY partenaire_name ASC";
  $stm_partenaire = $mysqli->query($sql_partenaire);

  //Formattager des profiles sous forme d'un tableau clde=>value
  $partenaires = $stm_partenaire->fetch_all(MYSQLI_ASSOC);

  //Recuperation de tous les groupes
  $sql_groupe = "SELECT * FROM groupes ORDER BY groupe_nom ASC";
  $stm_groupe = $mysqli->query($sql_groupe);

  //Formattager des profiles sous forme d'un tableau clde=>value
  $groupes = $stm_groupe->fetch_all(MYSQLI_ASSOC);

?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="CRB Team">

	<title>Gestion de projet - Nouveau utilisateur</title>
	<link href="./assets/css/bootstrap.min.css" rel="stylesheet">
  <link href="./assets/css/sticky-footer.css" rel="stylesheet">
	<script type="text/javascript" src="./assets/js/jquery.js"></script>
    <script type="text/javascript" src="./assets/js/bootstrap.min.js"></script>

</head>
<body style="background-image:url(./photo/map_un.png); background-repeat : no-repeat; background-size : cover">
   <?php
    include('sous_menu_projet.php');
    ?>
   <div class="container">
   	  <div class="row">
   	  	<legend>
   	  		Editer un utilisateur

   	  	    <div class="pull-right">
              <!-- Lien vers la liste des uilisateurs -->
	   	  		<a class="btn btn-primary btn-sm" href="./utilisateur_liste.php">Liste</a>
	   	  	</div>
	   	</legend>
   	  </div>
	<div class="col-md-12" style='background:whitesmoke'>
   	     <p id="message"></p>
   	  	<div class="row">
   	  		<div class="col-md-6">
            <!-- Champ pour nom -->
   	  		 Nom<br>
   	  		 <input type="hidden" name="user_id" id="user_id" value="<?=$user['user_id']?>">
   	  		 <input type="text" name="first_name" id="first_name" value="<?=$user['first_name']?>" class="form-control">
   	  		 <p id="error_first_name" class="text-danger"></p>
   	  	    </div>

   	  	    <div class="col-md-6">
              <!-- Chmap pour un prenom -->
   	  		  Prénom<br>
            <input type="text" name="last_name" id="last_name" value="<?=$user['last_name']?>" class="form-control">
            <p id="error_last_name" class="text-danger"></p>
   	  	    </div>
   	  	</div>
   	  	<div class="row">
   	  		<div class="col-md-6">
           <!-- Chmap pour nom d'utilisateur -->
   	  		  Login<br>
            <input type="text" name="username" id="username" value="<?=$user['username']?>" class="form-control">
            <p id="error_username" class="text-danger"></p>

   	  	    </div>
   	  	    <div class="col-md-6">
              <!-- Champ pour email -->
   	  		  Email<br>
   	  		  <input type="text" name="email" id="email" value="<?=$user['email']?>" class="form-control">
            <p id="error_email" class="text-danger"></p>
   	  	    </div>
   	  	</div>
   	  	
   	  	<div class="row">
   	  		<div class="col-md-6">
           <!-- Champ pour le mot de passe -->
   	  		  Mot de passe<br>
            <input type="text" name="motDePasse" id="motDePasse" value="" class="form-control">
            <p id="errorMotDePasse" class="text-danger"></p>

   	  	    </div>
   	  	    <div class="col-md-6">
              <!-- Champ pour retaper le mot de pass -->
   	  		  Confirmer le mot de passe<br>
   	  		  <input type="text" name="confMotDePasse" id="confMotDePasse" value="" class="form-control">
            <p id="" class="text-danger"></p>
   	  	    </div>
   	  	</div>
   	  	
   	  	<div class="row">
   	  		<div class="col-md-6">
            <!-- Champ pour telephone -->
   	  		  Télephone<br>
   	  		  <input type="text" name="telephone" value="<?=$user['telephone']?>" id="telephone" class="form-control">
            <p id="error_telephone" class="text-danger"></p>

   	  	    </div>
   	  	    <div class="col-md-6">
              <!-- Champ des profiles -->
   	  		  Profile<br>
            <select class="form-control" name="profil_id" id="profil_id">
              <option value="0"> - Sélectionner - </option>
              <?php

              foreach ($profils as $profil) {
               ?>
                <option <?php if($profil['profil_id'] == $user['profil_id']) echo 'selected';?> value="<?=$profil['profil_id']?>"><?=$profil['profil_descr']?></option>
               <?php
              }
            ?>
            </select>
            <p id="error_profil_id" class="text-danger"></p>

   	  	    </div>
   	  	</div>

         <div class="row" id="partenaire_div">
          <div class="col-md-6">
            <!-- Champ du profile des utilisateurs -->

            Partenaire<br>
            <select class="form-control" name="partenaire_id" id="partenaire_id">
              <option value="0"> - Sélectionner - </option>
              <?php

              foreach ($partenaires as $partenaire) {
              ?>
                <option <?php if($partenaire['partenaire_id'] == $user['partenaire_id']) echo 'selected';?> value="<?=$partenaire['partenaire_id']?>"><?php echo htmlentities($partenaire['partenaire_name']);?></option>
              <?php
              }
            ?>
            </select>
            <p id="error_partenaire_id" class="text-danger"></p>

   	  	  </div>

           <div class="col-md-6">
            <!-- Champ du profile des utilisateurs -->

            Groupes<br>
            <select class="form-control" name="groupe_id" id="groupe_id">
              <option value="0"> - Sélectionner - </option>
              <?php

              foreach ($groupes as $groupe) {
              ?>
                <option <?php if($groupe['groupe_id'] == $user['groupe_id']) echo 'selected';?> value="<?=$groupe['groupe_id']?>"><?php echo htmlentities($groupe['groupe_nom']);?></option>
              <?php
              }
            ?>
            </select>
            <p id="error_groupe_id" class="text-danger"></p>
   	  	  </div>
        </div>

   	  	<div class="row" style="margin-top: 20px">
           <div class="col-md-6">
             <!-- Bouttons pour enregistrer les modifications -->
          <button class="btn btn-primary btn-sm" id="save">Enregister les modifications</button>
           </div>
        </div>
	</div>
   </div>
   <?php
    //include('footer.php');
    ?>
</body>
<script type="text/javascript">
	$(document).ready(function(){

      $("#partenaire_div").hide();
        let profil_id = "<?php echo $user['profil_id']?>";
        if(profil_id == 14){
          $("#partenaire_div").show();
        }else{
          $("#partenaire_div").hide();
        }

      //Verifier le code du profil
      $("#profil_id").change(()=>{
        let profil_id = $("#profil_id").val();        
        
        if(profil_id == 14){
          $("#partenaire_div").show();
        }else{
          $("#partenaire_div").hide();
        }
      })


    // Cas on fait un click sur un boutton enregistrer
      $("#save").click(function(){
        // Recuperation des information completer
      	var user_id = $("#user_id").val();
      	var first_name = $("#first_name").val();
      	var last_name = $("#last_name").val();
      	var email = $("#email").val();
      	var telephone = $("#telephone").val();
      	var username = $("#username").val();
        var profil_id = $("#profil_id").val();
        var partenaire_id = $("#partenaire_id").val();
        var groupe_id = $("#groupe_id").val();  
        var motDePasse = $("#motDePasse").val();
        var confMotDePasse = $("#confMotDePasse").val();

        // Vider les champs d'erreurs
        $("#error_first_name").html(" ");
    	$("#error_last_name").html(" ");
    	$("#error_email").html(" ");
    	$("#error_telephone").html(" ");
    	$("#error_username").html(" ");
        $("#error_profil_id").html(" ");
        $("#error_partenaire_id").html(" ");
        $("#errorMotDePasse").html(" ");

        // Mot de passe
      	if(motDePasse.length > 0 && motDePasse.length < 8){
          // message si le champ est invalide
            $("#errorMotDePasse").html("Le mot de passe doit avoir au moins <b>8</b> caractères.");
      	}
      	
      	// Mot de passe
      	if(motDePasse != confMotDePasse){
          // message si le champ est invalide
            $("#errorMotDePasse").html("Mots de passe differents.");
      	}
      	
      	// Validation du nom de l'utilisateur
      	if(first_name.length < 2){
          // message si le champ est invalide
            $("#error_first_name").html("Un nom doit avoir au moin <b>2</b> caractères.");
      	}

        // Validation du prenom de l'utilisateur
      	if(last_name.length < 2){
          // message si le champ est invalide
          $("#error_last_name").html("Un prénom doit avoir au moin <b>2</b> caractères.");
      	}

        // Validation du nom d'utilisateur
      	if(username.length < 2){
          // message si le champ est invalide
            $("#error_username").html("Le champ <b>période</b> est réquis");
      	}

        // Validation du telephone de l'utilisateur
      	if(telephone.length < 1){
          // message si le champ est invalide
            $("#error_telephone").html("Le champ <b>Télephone</b> est réquis");
      	}

        // Validation de l'email de l'utilisateur
      	if(email.length < 4){
          // message si le champ est invalide
            $("#error_email").html("Le champ <b>Vérifier</b> est réquis");
      	}

        // Validation du profile de l'utilisateur
      	if(profil_id < 1){
          // message si le champ est invalide
            $("#error_profil_id").html("Le champ <b>profil</b> est réquis");
      	}



        // Si les champs obligatoires sont completer
       
      	if(first_name !='' && last_name !='' && username !='' && telephone !='' && email != '' && profil_id > 0 && motDePasse == confMotDePasse && (motDePasse.length == 0 || motDePasse.length >= 8 )){
          $.ajax({
                url: './model/model_utilisateur_update.php',
                type: 'POST',
                dataType: 'JSON',
                data: {
                	user_id:user_id,
                	first_name:first_name,
                	last_name:last_name,
                    username:username,
                    telephone:telephone,
                    email:email,
                    profil_id:profil_id,
                    partenaire_id:partenaire_id,
                    groupe_id:groupe_id,
                    motDePasse:motDePasse
                },
                success:function(data){
                  // Message retourne apres enregistrement
                  $("#message").html(data.message);

                  // Si l'operation a bien passé on fait une redirection apres 1 seconde sur la liste des projet
                  
                  setTimeout(function(){
                      window.location.href = './utilisateur_liste.php';
                  }, 2000);
                }
            });
      	}
      });

	});
</script>
</html>
