<?php
// Initialisation des variables de session
  session_start();
  $user_id = $_SESSION['user_id'];
  $profil_id = $_SESSION['profil_id'];

  //Verfication si l'utilisateur est authentifié
  if($user_id < 1){
    // Si non on fait une redirection sur la page d'authefication
    header('Location: ./index.php');
  }

  //Connection a la base de donnees
  //$mysqli = new mysqli("localhost","root","","crb_care");
   include ('connexion.php');

  //Recuperation de l'ID du partenaire
  $partenaire_id = isset($_GET['partenaire_id'])?$_GET['partenaire_id']:null;

  //Recuperation de l'ID de l'indicateur
  $indicateur_id = isset($_GET['indicateur_id'])?$_GET['indicateur_id']:null;

  // Selection du partenaire concerné
  $sql_partenaire = "SELECT * FROM partenaires WHERE partenaire_id = $partenaire_id";
  $stm_partenaire = $mysqli->query($sql_partenaire);
  // Formattage du donnees recuperés sous forme d'un tableau cle=>value
  $partenaire = $stm_partenaire->fetch_array(MYSQLI_ASSOC);

  // Selection de l'indicateur concerné
  $sql_indicateur = "SELECT * FROM indicateurs WHERE indicateur_id = $indicateur_id";
  $stm_indicateur = $mysqli->query($sql_indicateur);
  // Formattage du donnees recuperés sous forme d'un tableau cle=>value
  $indicateur = $stm_indicateur->fetch_array(MYSQLI_ASSOC);
  
  $typecible = '';
  $type_cible_id = $indicateur['type_cible_id'];
  if($type_cible_id > 0){
	  $sql_typ_cible = $mysqli->query("SELECT * FROM type_cible WHERE id = $type_cible_id ");
	  $type_cible = $sql_typ_cible->fetch_array(MYSQLI_ASSOC);
	  $typecible = $type_cible['description'];
  }

  $mysqli -> close();

?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="CRB Team">

	<title>Gestion de partenaire - Résultats des indicateurs</title>
	<link href="./assets/css/bootstrap.min.css" rel="stylesheet">
  <link href="./assets/css/sticky-footer.css" rel="stylesheet">
	<script type="text/javascript" src="./assets/js/jquery.js"></script>
    <script type="text/javascript" src="./assets/js/bootstrap.min.js"></script>

</head>
<body style="background-image:url(./photo/map_un.png); background-repeat : no-repeat; background-size : cover">
  <?php
    include('sous_menu_projet.php');
    ?>
   <div class="container">
   	  <div class="row">
   	  	<legend>
   	  		  Résultats de l'indicateur
   	  	    <div class="pull-right">
	   	  		<a class="btn btn-primary btn-sm" href="./indicateur_liste.php?partenaire_id=<?=$partenaire_id?>">Liste des indicateurs</a>
	   	  	</div>
	   	</legend>
   	  </div>
      <nav aria-label="breadcrumb">
        <!-- informations indicatifs de l'indicateurs -->
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="./indicateur_liste.php?partenaire_id=<?=$partenaire_id?>"><?=$partenaire['partenaire_name']." (<b>".$partenaire['partenaire_code']?></b>)</a></li>
          <li class="breadcrumb-item"><a href="#"><?=$indicateur['indicateur_nom']."(<b>".$indicateur['indicateur_code']?></b>)</a></li>
          <li class="breadcrumb-item active">Cibles :<b><?= number_format($indicateur['cible'],0,'',' ')?></b></li>
          <li class="breadcrumb-item active" aria-current="page">Résultats atteint:<b><?= number_format($indicateur['cible_atteint'],0,'',' ')?></b></li>
        </ol>
      </nav>
	  <div class="col-md-12" style='background:whitesmoke'>
        <!-- Espace pur afficahe des messages apres operations -->
   	    <p id="message"></p>

        <div class="row">
		<!-- Type de cible -->
          <div class="col-md-2">
   	  		 Type de cible<br>
             <input type="text" value="<?=$typecible?>" class="form-control" readonly>
          </div>
		  
          <!-- Champ pour resulat atteint -->
          <div class="col-md-3">
             Résultats atteints<br>
             <input type="number" name="cible" id="cible" class="form-control">
             <input type="hidden" name="indicateur_id" id="indicateur_id" value="<?=$indicateur['indicateur_id']?>">
   	  		 <input type="hidden" name="partenaire_id" id="partenaire_id" value="<?=$partenaire_id?>">
             <!-- Zone du message d'erreur -->
   	  		   <p id="error_cible" class="text-danger"></p>
          </div>
			
		  
          <!-- Champ pour le commentaire -->
          <div class="col-md-2">
   	  		 Observation<br>
             <input type="text" name="commentaire" id="commentaire" class="form-control">
          </div>

          <!-- Bouton pour enregistrement -->
          <div class="col-md-2" style="margin-top: 20px">
   	  		 <button class="btn btn-primary btn-sm btn-block" id="save">Enregister</button>
   	  	  </div>
   	  	</div>
	</div>
        <div id='decaissements' style='background:whitesmoke' ></div>
   </div>
   <?php
    include('footer.php');
    ?>
</body>
<script type="text/javascript">
	$(document).ready(function(){
   // Appel de la foction qui retourne les resulats obtenus en fonction du cible, lors du chargement de la page
    getList();

    // Fonction pour les resulats atteints en fonction du cible
    function getList(){
      var indicateur_id = $("#indicateur_id").val();
      var partenaire_id = $("#partenaire_id").val();
        if(indicateur_id > 0){
            $.ajax({
                url: './model/model_indicateurs_decaissement_liste.php?indicateur_id='+indicateur_id+'&partenaire_id='+partenaire_id,
                type: 'GET',
                dataType: 'JSON',
                success:function(data){
                  $("#decaissements").html(data.decaissements);
                }
            });
        }
      }

      function supprimer(event){
        const id = event.target.id;
        console.log('ID '+id);
      }

      //Lors click sur le bouton enregistrer,
      $("#save").click(function(){
        // Recuperation des informations du formulaire
      	var indicateur_id = $("#indicateur_id").val();
      	var cible = $("#cible").val();
      	var commentaire = $("#commentaire").val();

        //Vider les champs contants les messages d'erreurs
        $("#error_cible").html(" ");
	      $("#message").html(" ");

        //Validation du champ indicateur_id > 0
      	if(indicateur_id < 1){
          //  Message d'erreur en cas de l'invalidité
            $("#message").html("Il faut verifier l'ID de la tache");
      	}

        //Validation du champ cible est > 0
      	if(cible < 1){
          //  Message d'erreur en cas de l'invalidité
            $("#error_cible").html("Le champ <b>cible</b> est réquis");
      	}


      	if(cible >0 && indicateur_id > 0){
          // Si les champs sont valides, on envoie le resulat pour etre suavegarder
          $.ajax({
                url: './model/model_indicateur_decaissement.php',
                type: 'POST',
                dataType: 'JSON',
                data: {
                    cible:cible,
                	indicateur_id:indicateur_id,
                    commentaire:commentaire
                },
                success:function(data){
                  // Affichage du message apres operations
                   $("#message").html(data.message);
          					if(data.status == 200){

          						$("#cible").val('');
                      $("#commentaire").val('');
                      const partenaire_id = $("#partenaire_id").val();
                      // si l'operation a bien passe, on fait une redirection
                      window.location.href = './indicateurs_histo.php?indicateur_id='+indicateur_id+'&partenaire_id='+partenaire_id;
          					}

                }
            });
      	}
      });

	});
</script>
</html>
