<?= $this->extend(config('Auth')->views['layout']) ?>

<?= $this->section('title') ?><?= lang('Auth.register') ?> <?= $this->endSection() ?>

<?= $this->section('main') ?>

<div class="card card-secondary bg-secondary">
    <div class="card-header text-center">
        <a href="#" class="h1 text-uppercase"><b><?= lang('Auth.register') ?></b></a>
    </div>
    <div class="card-body">
        <!-- <h5 class="card-title mb-5"><?= lang('Auth.register') ?></h5> -->

        <?php if (session('error') !== null) : ?>
            <div class="alert alert-danger" role="alert"><?= session('error') ?></div>
        <?php elseif (session('errors') !== null) : ?>
            <div class="alert alert-danger" role="alert">
                <?php if (is_array(session('errors'))) : ?>
                    <?php foreach (session('errors') as $error) : ?>
                        <?= $error ?>
                        <br>
                    <?php endforeach ?>
                <?php else : ?>
                    <?= session('errors') ?>
                <?php endif ?>
            </div>
        <?php endif ?>

        <form action="<?= url_to('register') ?>" method="post">
            <?= csrf_field() ?>

            <!-- Email -->
            <div class="form-floating mb-2">
                <label for="floatingEmailInput"><?= lang('Auth.email') ?></label>
                <input type="email" class="form-control" id="floatingEmailInput" name="email" inputmode="email" autocomplete="email" placeholder="<?= lang('Auth.email') ?>" value="<?= old('email') ?>" required>
            </div>

            <!-- Username -->
            <div class="form-floating mb-4">
                <label for="floatingUsernameInput"><?= lang('Auth.username') ?></label>
                <input type="text" class="form-control" id="floatingUsernameInput" name="username" inputmode="text" autocomplete="username" placeholder="<?= lang('Auth.username') ?>" value="<?= old('username') ?>" required>
            </div>

            <!-- Password -->
            <div class="form-floating mb-2">
                <label for="floatingPasswordInput"><?= lang('Auth.password') ?></label>

                <input type="password" class="form-control" id="floatingPasswordInput" name="password" inputmode="text" autocomplete="new-password" placeholder="<?= lang('Auth.password') ?>" required>
            </div>

            <!-- Password (Again) -->
            <div class="form-floating mb-3">
                <label for="floatingPasswordConfirmInput"><?= lang('Auth.passwordConfirm') ?></label>

                <input type="password" class="form-control" id="floatingPasswordConfirmInput" name="password_confirm" inputmode="text" autocomplete="new-password" placeholder="<?= lang('Auth.passwordConfirm') ?>" required>
            </div>
            <div class="form-floating mb-3">
                <p> <span class="text-danger fa fa-exclamation"></span> Le mot de passe doit contenir au moins 8 caractères.</p>
            </div>

            <div class="d-grid col-12 col-md-8 mx-auto">
                <button type="submit" class="btn btn-default btn-block"><?= lang('Auth.register') ?></button>
            </div>

        </form>
    </div>
    <div class="card-footer">
        <p class="text-center"><?= lang('Auth.haveAccount') ?> <a style="color:#89D3DF" href="<?= url_to('login') ?>"><?= lang('Auth.login') ?></a></p>
    </div>
</div>
</div>

<?= $this->endSection() ?>