<?= $this->extend(config('Auth')->views['layout']) ?>

<?= $this->section('title') ?><?= lang('Auth.login') ?> <?= $this->endSection() ?>

<?= $this->section('main') ?>

<!-- <div class="card card-outline card-primary"> -->
<div class="card card-secondary bg-secondary">
    <div class="card-header text-center">
        <a href="#" class="h1 text-uppercase"><b><?= lang('Auth.login') ?></b></a>
    </div>

    
    <div class="card-body">
        <h5 class="card-title mb-5"></h5>
        <?php if (session('error') !== null) : ?>
            <div class="alert alert-danger" role="alert"><?= session('error') ?></div>
        <?php elseif (session('errors') !== null) : ?>
            <div class="alert alert-danger" role="alert">
                <?php if (is_array(session('errors'))) : ?>
                    <?php foreach (session('errors') as $error) : ?>
                        <?= $error ?>
                        <br>
                    <?php endforeach ?>
                <?php else : ?>
                    <?= session('errors') ?>
                <?php endif ?>
            </div>
        <?php endif ?>

        <?php if (session('message') !== null) : ?>
            <div class="alert alert-success" role="alert"><?= session('message') ?></div>
        <?php endif ?>

        <form action="<?= url_to('login') ?>" method="post">
            <?= csrf_field() ?>

            <!-- Email -->
            <div class="form-floating mb-3">
                <!-- <label for="floatingEmailInput"><?= lang('Auth.email') ?></label> -->
                <input type="email" class="form-control" id="floatingEmailInput" name="email" inputmode="email" autocomplete="email" placeholder="<?= lang('Auth.email') ?>" value="<?= old('email') ?>" required>
            </div>

            <!-- Password -->
            <div class="form-floating mb-3">
                <!-- <label for="floatingPasswordInput"><?= lang('Auth.password') ?></label> -->
                <input type="password" class="form-control" id="floatingPasswordInput" name="password" inputmode="text" autocomplete="current-password" placeholder="<?= lang('Auth.password') ?>" required>
            </div>

            <div class="row">
                <!-- Remember me -->
                <?php if (setting('Auth.sessionConfig')['allowRemembering']) : ?>
                    <div class="col-7">

                        <div class="form-check">
                            <label class="form-check-label">
                                <input type="checkbox" name="remember" class="form-check-input" <?php if (old('remember')) : ?> checked<?php endif ?>>
                                <?= lang('Auth.rememberMe') ?>
                            </label>
                        </div>
                    </div>
                <?php endif; ?>

                <div class="col-5">
                    <button type="submit" class="btn btn-default btn-block"><?= lang('Auth.login') ?></button>
                </div>
            </div>


        </form>
    </div>

    <div class="card-footer">
        <?php if (setting('Auth.allowMagicLinkLogins')) : ?>
            <p class="text-center"><?= lang('Auth.forgotPassword') ?> <a style="color:#89D3DF" href="<?= url_to('magic-link') ?>"><?= lang('Auth.useMagicLink') ?></a></p>
        <?php endif ?>

        <?php if (setting('Auth.allowRegistration')) : ?>
            <p class="text-center"><?= lang('Auth.needAccount') ?> <a style="color:#89D3DF" href="<?= url_to('register') ?>"><?= lang('Auth.register') ?></a></p>
        <?php endif ?>
    </div>
</div>
<!-- </div> -->

<?= $this->endSection() ?>