<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Pays extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 5,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'description' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'default' => NULL,
            ],
            'created_at DATETIME default current_timestamp',
            'updated_at DATETIME default NULL',
            'deleted_at DATETIME default NULL',
        ]);
        $this->forge->addKey('id', true);
        $this->forge->createTable('pays');
    }

    public function down()
    {
        $this->forge->dropTable('pays');
    }
}
