<?php

namespace Modules\Volontaire\Controllers;

use App\Controllers\BaseController;
use CodeIgniter\HTTP\ResponseInterface;
use Modules\Volontaire\Models\Documents as ModelsDocuments;
use App\Traits\DocumentTrait;
use CodeIgniter\HTTP\RequestInterface;
use Psr\Log\LoggerInterface;

class Documents extends BaseController
{
    protected ModelsDocuments $documentModel;

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
       parent::initController($request, $response, $logger);
       $this->documentModel = new ModelsDocuments(); 
    }
    public function index()
    {
        $this->viewData['url_list'] = "";
        $this->viewData['js'] = "";

        $documents = $this->documentModel->where('userId', \auth()->user()->id)->findAll();
        $this->viewData['types'] = DocumentTrait::types();
        $this->viewData['documents'] = $documents;

        return view('volonatire/document/index', $this->viewData);
    }

    function add()
    {
        if (!$this->validate($this->valideForm())) {
            $this->viewData['url_list'] = "";
            $this->viewData['js'] = "";

            $documents = $this->documentModel->where('userId', \auth()->user()->id)->findAll();
            $this->viewData['types'] = DocumentTrait::types();
            $this->viewData['documents'] = $documents;

            return view('volonatire/document/index', $this->viewData);
        } else {

           $stmt = $this->documentModel->save($this->document());


            if ($stmt) {
                $this->session->setFlashdata('message', "<alert class='ml-2 alert alert-success'>Document enregistré avec succès</alert>");
                return redirect()->to(site_url($this->viewData['locale'] . '/volontaire/document'));
            }
        }
    }


    function document()
    {
        $file = $this->request->getFile('path');
        $user = \auth()->user();

        $document =[];
        $document['type'] = $this->request->getPost('type');

        if ($file->isValid() && !$file->hasMoved()) {
            $newName = $file->getRandomName();
            $file->move('uploads/documents/', $newName);
            $document['documentPath'] = $newName;
        }

        $document['userId'] = $user->id;

        return $document;
    }

    function delete()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $doc = $this->documentModel->find($id);
        $stmnt = $this->documentModel->delete($id);

        if ($stmnt) {
            unlink('uploads/documents/'.$doc->documentPath);
            $this->session->setFlashdata('message', "<alert class='ml-2 alert alert-success'>Document est supprimé avec succès</alert>");            
            return redirect()->to(site_url($this->viewData['locale'] . '/volontaire/document'));
        }
    }

    private function valideForm()
    {
        $rules = [];
        $rules['type']      = ['rules'  => 'required'];
        $rules['path'] = [
            'uploaded[path]',
            'max_size[path,12024]',
           // 'is_image[path]'
        ];
        return $rules;
    }
}
